/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class AbstractSqlQueryRequest
extends AbstractSqlRequest
implements CompositeIndicesRequest,
ToXContentFragment {
    private String query = "";
    private TimeZone timeZone = Protocol.TIME_ZONE;
    private int fetchSize = 1000;
    private TimeValue requestTimeout = Protocol.REQUEST_TIMEOUT;
    private TimeValue pageTimeout = Protocol.PAGE_TIMEOUT;
    @Nullable
    private QueryBuilder filter = null;
    private List<SqlTypedParamValue> params = Collections.emptyList();

    public AbstractSqlQueryRequest() {
    }

    public AbstractSqlQueryRequest(Mode mode, String query, List<SqlTypedParamValue> params, QueryBuilder filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout) {
        super(mode);
        this.query = query;
        this.params = params;
        this.timeZone = timeZone;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
    }

    protected static <R extends AbstractSqlQueryRequest> ObjectParser<R, Void> objectParser(Supplier<R> supplier) {
        ObjectParser<R, Void> parser = new ObjectParser<R, Void>("sql/query", true, supplier);
        parser.declareString(AbstractSqlQueryRequest::query, new ParseField("query", new String[0]));
        parser.declareObjectArray(AbstractSqlQueryRequest::params, (p, c) -> SqlTypedParamValue.fromXContent(p), new ParseField("params", new String[0]));
        parser.declareString((request, zoneId) -> request.timeZone(TimeZone.getTimeZone(zoneId)), new ParseField("time_zone", new String[0]));
        parser.declareInt(AbstractSqlQueryRequest::fetchSize, new ParseField("fetch_size", new String[0]));
        parser.declareString((request, timeout) -> request.requestTimeout(TimeValue.parseTimeValue(timeout, Protocol.REQUEST_TIMEOUT, "request_timeout")), new ParseField("request_timeout", new String[0]));
        parser.declareString((request, timeout) -> request.pageTimeout(TimeValue.parseTimeValue(timeout, Protocol.PAGE_TIMEOUT, "page_timeout")), new ParseField("page_timeout", new String[0]));
        parser.declareObject(AbstractSqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), new ParseField("filter", new String[0]));
        return parser;
    }

    public String query() {
        return this.query;
    }

    public AbstractSqlQueryRequest query(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query may not be null.");
        }
        this.query = query;
        return this;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public AbstractSqlQueryRequest params(List<SqlTypedParamValue> params) {
        if (params == null) {
            throw new IllegalArgumentException("params may not be null.");
        }
        this.params = params;
        return this;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public AbstractSqlQueryRequest timeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone may not be null.");
        }
        this.timeZone = timeZone;
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public AbstractSqlQueryRequest fetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("fetch_size must be more than 0.");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public AbstractSqlQueryRequest requestTimeout(TimeValue requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public AbstractSqlQueryRequest pageTimeout(TimeValue pageTimeout) {
        this.pageTimeout = pageTimeout;
        return this;
    }

    public AbstractSqlQueryRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public AbstractSqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.query = in.readString();
        this.params = in.readList(AbstractSqlQueryRequest::readSqlTypedParamValue);
        this.timeZone = TimeZone.getTimeZone(in.readString());
        this.fetchSize = in.readVInt();
        this.requestTimeout = in.readTimeValue();
        this.pageTimeout = in.readTimeValue();
        this.filter = in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    public static void writeSqlTypedParamValue(StreamOutput out, SqlTypedParamValue value) throws IOException {
        out.writeEnum(value.dataType);
        out.writeGenericValue(value.value);
    }

    public static SqlTypedParamValue readSqlTypedParamValue(StreamInput in) throws IOException {
        return new SqlTypedParamValue(in.readEnum(DataType.class), in.readGenericValue());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.query);
        out.writeVInt(this.params.size());
        for (SqlTypedParamValue param : this.params) {
            AbstractSqlQueryRequest.writeSqlTypedParamValue(out, param);
        }
        out.writeString(this.timeZone.getID());
        out.writeVInt(this.fetchSize);
        out.writeTimeValue(this.requestTimeout);
        out.writeTimeValue(this.pageTimeout);
        out.writeOptionalNamedWriteable(this.filter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSqlQueryRequest that = (AbstractSqlQueryRequest)o;
        return this.fetchSize == that.fetchSize && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.timeZone, this.fetchSize, this.requestTimeout, this.pageTimeout, this.filter);
    }
}

