/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.rescore.QueryRescoreMode;
import org.elasticsearch.search.rescore.QueryRescorer;
import org.elasticsearch.search.rescore.RescorerBuilder;

public class QueryRescorerBuilder
extends RescorerBuilder<QueryRescorerBuilder> {
    public static final String NAME = "query";
    private static final ParseField RESCORE_QUERY_FIELD = new ParseField("rescore_query", new String[0]);
    private static final ParseField QUERY_WEIGHT_FIELD = new ParseField("query_weight", new String[0]);
    private static final ParseField RESCORE_QUERY_WEIGHT_FIELD = new ParseField("rescore_query_weight", new String[0]);
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ObjectParser<InnerBuilder, Void> QUERY_RESCORE_PARSER = new ObjectParser("query", null);
    public static final float DEFAULT_RESCORE_QUERYWEIGHT = 1.0f;
    public static final float DEFAULT_QUERYWEIGHT = 1.0f;
    public static final QueryRescoreMode DEFAULT_SCORE_MODE;
    private final QueryBuilder queryBuilder;
    private float rescoreQueryWeight = 1.0f;
    private float queryWeight = 1.0f;
    private QueryRescoreMode scoreMode = DEFAULT_SCORE_MODE;

    public QueryRescorerBuilder(QueryBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("rescore_query cannot be null");
        }
        this.queryBuilder = builder;
    }

    public QueryRescorerBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryBuilder = in.readNamedWriteable(QueryBuilder.class);
        this.scoreMode = QueryRescoreMode.readFromStream(in);
        this.rescoreQueryWeight = in.readFloat();
        this.queryWeight = in.readFloat();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.queryBuilder);
        this.scoreMode.writeTo(out);
        out.writeFloat(this.rescoreQueryWeight);
        out.writeFloat(this.queryWeight);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public QueryBuilder getRescoreQuery() {
        return this.queryBuilder;
    }

    public QueryRescorerBuilder setQueryWeight(float queryWeight) {
        this.queryWeight = queryWeight;
        return this;
    }

    public float getQueryWeight() {
        return this.queryWeight;
    }

    public QueryRescorerBuilder setRescoreQueryWeight(float rescoreQueryWeight) {
        this.rescoreQueryWeight = rescoreQueryWeight;
        return this;
    }

    public float getRescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    public QueryRescorerBuilder setScoreMode(QueryRescoreMode scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    public QueryRescoreMode getScoreMode() {
        return this.scoreMode;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(RESCORE_QUERY_FIELD.getPreferredName(), this.queryBuilder);
        builder.field(QUERY_WEIGHT_FIELD.getPreferredName(), this.queryWeight);
        builder.field(RESCORE_QUERY_WEIGHT_FIELD.getPreferredName(), this.rescoreQueryWeight);
        builder.field(SCORE_MODE_FIELD.getPreferredName(), this.scoreMode.name().toLowerCase(Locale.ROOT));
        builder.endObject();
    }

    public static QueryRescorerBuilder fromXContent(XContentParser parser) throws IOException {
        InnerBuilder innerBuilder = QUERY_RESCORE_PARSER.parse(parser, new InnerBuilder(), null);
        return innerBuilder.build();
    }

    @Override
    public QueryRescorer.QueryRescoreContext innerBuildContext(int windowSize, QueryShardContext context) throws IOException {
        QueryRescorer.QueryRescoreContext queryRescoreContext = new QueryRescorer.QueryRescoreContext(windowSize);
        queryRescoreContext.setQuery(this.queryBuilder.toQuery(context));
        queryRescoreContext.setQueryWeight(this.queryWeight);
        queryRescoreContext.setRescoreQueryWeight(this.rescoreQueryWeight);
        queryRescoreContext.setScoreMode(this.scoreMode);
        return queryRescoreContext;
    }

    @Override
    public final int hashCode() {
        int result = super.hashCode();
        return 31 * result + Objects.hash(this.scoreMode, Float.valueOf(this.queryWeight), Float.valueOf(this.rescoreQueryWeight), this.queryBuilder);
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryRescorerBuilder other = (QueryRescorerBuilder)obj;
        return super.equals(obj) && Objects.equals(this.scoreMode, other.scoreMode) && Objects.equals(Float.valueOf(this.queryWeight), Float.valueOf(other.queryWeight)) && Objects.equals(Float.valueOf(this.rescoreQueryWeight), Float.valueOf(other.rescoreQueryWeight)) && Objects.equals(this.queryBuilder, other.queryBuilder);
    }

    @Override
    public QueryRescorerBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryBuilder rewrite = this.queryBuilder.rewrite(ctx);
        if (rewrite == this.queryBuilder) {
            return this;
        }
        QueryRescorerBuilder queryRescoreBuilder = new QueryRescorerBuilder(rewrite);
        queryRescoreBuilder.setQueryWeight(this.queryWeight);
        queryRescoreBuilder.setRescoreQueryWeight(this.rescoreQueryWeight);
        queryRescoreBuilder.setScoreMode(this.scoreMode);
        return queryRescoreBuilder;
    }

    static {
        QUERY_RESCORE_PARSER.declareObject(InnerBuilder::setQueryBuilder, (p, c) -> {
            try {
                return AbstractQueryBuilder.parseInnerQueryBuilder(p);
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "Could not parse inner query", e, new Object[0]);
            }
        }, RESCORE_QUERY_FIELD);
        QUERY_RESCORE_PARSER.declareFloat(InnerBuilder::setQueryWeight, QUERY_WEIGHT_FIELD);
        QUERY_RESCORE_PARSER.declareFloat(InnerBuilder::setRescoreQueryWeight, RESCORE_QUERY_WEIGHT_FIELD);
        QUERY_RESCORE_PARSER.declareString((struct, value) -> struct.setScoreMode(QueryRescoreMode.fromString(value)), SCORE_MODE_FIELD);
        DEFAULT_SCORE_MODE = QueryRescoreMode.Total;
    }

    private static class InnerBuilder {
        private QueryBuilder queryBuilder;
        private float rescoreQueryWeight = 1.0f;
        private float queryWeight = 1.0f;
        private QueryRescoreMode scoreMode = DEFAULT_SCORE_MODE;

        private InnerBuilder() {
        }

        void setQueryBuilder(QueryBuilder builder) {
            this.queryBuilder = builder;
        }

        QueryRescorerBuilder build() {
            QueryRescorerBuilder queryRescoreBuilder = new QueryRescorerBuilder(this.queryBuilder);
            queryRescoreBuilder.setQueryWeight(this.queryWeight);
            queryRescoreBuilder.setRescoreQueryWeight(this.rescoreQueryWeight);
            queryRescoreBuilder.setScoreMode(this.scoreMode);
            return queryRescoreBuilder;
        }

        void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        void setScoreMode(QueryRescoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }
    }
}

