/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DatafeedUpdate
implements Writeable,
ToXContentObject {
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("datafeed_update", Builder::new);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final List<String> types;
    private final QueryBuilder query;
    private final AggregatorFactories.Builder aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;

    private DatafeedUpdate(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, List<String> types, QueryBuilder query, AggregatorFactories.Builder aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices;
        this.types = types;
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
    }

    public DatafeedUpdate(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readOptionalString();
        this.queryDelay = in.readOptionalTimeValue();
        this.frequency = in.readOptionalTimeValue();
        this.indices = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.types = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.aggregations = (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.scriptFields = in.readBoolean() ? in.readList(SearchSourceBuilder.ScriptField::new) : null;
        this.scrollSize = in.readOptionalVInt();
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readOptionalBoolean();
        }
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
    }

    public String getId() {
        return this.id;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.jobId);
        out.writeOptionalTimeValue(this.queryDelay);
        out.writeOptionalTimeValue(this.frequency);
        if (this.indices != null) {
            out.writeBoolean(true);
            out.writeStringList(this.indices);
        } else {
            out.writeBoolean(false);
        }
        if (this.types != null) {
            out.writeBoolean(true);
            out.writeStringList(this.types);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.aggregations);
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        if (out.getVersion().before(Version.V_5_5_0)) {
            out.writeOptionalBoolean(null);
        }
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.id);
        this.addOptionalField(builder, Job.ID, this.jobId);
        if (this.queryDelay != null) {
            builder.field(DatafeedConfig.QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        }
        if (this.frequency != null) {
            builder.field(DatafeedConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        this.addOptionalField(builder, DatafeedConfig.INDICES, this.indices);
        this.addOptionalField(builder, DatafeedConfig.TYPES, this.types);
        this.addOptionalField(builder, DatafeedConfig.QUERY, this.query);
        this.addOptionalField(builder, DatafeedConfig.AGGREGATIONS, this.aggregations);
        if (this.scriptFields != null) {
            builder.startObject(DatafeedConfig.SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.addOptionalField(builder, DatafeedConfig.SCROLL_SIZE, this.scrollSize);
        this.addOptionalField(builder, DatafeedConfig.CHUNKING_CONFIG, this.chunkingConfig);
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    String getJobId() {
        return this.jobId;
    }

    TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    TimeValue getFrequency() {
        return this.frequency;
    }

    List<String> getIndices() {
        return this.indices;
    }

    List<String> getTypes() {
        return this.types;
    }

    Integer getScrollSize() {
        return this.scrollSize;
    }

    QueryBuilder getQuery() {
        return this.query;
    }

    AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    long getHistogramIntervalMillis() {
        return ExtractorUtils.getHistogramIntervalMillis(this.aggregations);
    }

    boolean hasAggregations() {
        return this.aggregations != null && this.aggregations.count() > 0;
    }

    List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public DatafeedConfig apply(DatafeedConfig datafeedConfig, Map<String, String> headers) {
        if (!this.id.equals(datafeedConfig.getId())) {
            throw new IllegalArgumentException("Cannot apply update to datafeedConfig with different id");
        }
        DatafeedConfig.Builder builder = new DatafeedConfig.Builder(datafeedConfig);
        if (this.jobId != null) {
            builder.setJobId(this.jobId);
        }
        if (this.queryDelay != null) {
            builder.setQueryDelay(this.queryDelay);
        }
        if (this.frequency != null) {
            builder.setFrequency(this.frequency);
        }
        if (this.indices != null) {
            builder.setIndices(this.indices);
        }
        if (this.types != null) {
            builder.setTypes(this.types);
        }
        if (this.query != null) {
            builder.setQuery(this.query);
        }
        if (this.aggregations != null) {
            builder.setAggregations(this.aggregations);
        }
        if (this.scriptFields != null) {
            builder.setScriptFields(this.scriptFields);
        }
        if (this.scrollSize != null) {
            builder.setScrollSize(this.scrollSize);
        }
        if (this.chunkingConfig != null) {
            builder.setChunkingConfig(this.chunkingConfig);
        }
        if (!headers.isEmpty()) {
            Map<String, String> securityHeaders = headers.entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.setHeaders(securityHeaders);
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedUpdate)) {
            return false;
        }
        DatafeedUpdate that = (DatafeedUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(this.types, that.types) && Objects.equals(this.query, that.query) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, this.types, this.query, this.scrollSize, this.aggregations, this.scriptFields, this.chunkingConfig);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    boolean isNoop(DatafeedConfig datafeed) {
        return !(this.frequency != null && !Objects.equals(this.frequency, datafeed.getFrequency()) || this.queryDelay != null && !Objects.equals(this.queryDelay, datafeed.getQueryDelay()) || this.indices != null && !Objects.equals(this.indices, datafeed.getIndices()) || this.types != null && !Objects.equals(this.types, datafeed.getTypes()) || this.query != null && !Objects.equals(this.query, datafeed.getQuery()) || this.scrollSize != null && !Objects.equals(this.scrollSize, datafeed.getQueryDelay()) || this.aggregations != null && !Objects.equals(this.aggregations, datafeed.getAggregations()) || this.scriptFields != null && !Objects.equals(this.scriptFields, datafeed.getScriptFields()) || this.chunkingConfig != null && !Objects.equals(this.chunkingConfig, datafeed.getChunkingConfig()));
    }

    static {
        PARSER.declareString(Builder::setId, DatafeedConfig.ID);
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDEXES);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDICES);
        PARSER.declareStringArray(Builder::setTypes, DatafeedConfig.TYPES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.QUERY_DELAY.getPreferredName())), DatafeedConfig.QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.FREQUENCY.getPreferredName())), DatafeedConfig.FREQUENCY);
        PARSER.declareObject(Builder::setQuery, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), DatafeedConfig.QUERY);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((XContentParser)p), DatafeedConfig.AGGREGATIONS);
        PARSER.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((XContentParser)p), DatafeedConfig.AGGS);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
            }
            parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            return parsedScriptFields;
        }, DatafeedConfig.SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, DatafeedConfig.SCROLL_SIZE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.CONFIG_PARSER, DatafeedConfig.CHUNKING_CONFIG);
    }

    public static class Builder {
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices;
        private List<String> types;
        private QueryBuilder query;
        private AggregatorFactories.Builder aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize;
        private ChunkingConfig chunkingConfig;

        public Builder() {
        }

        public Builder(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DatafeedConfig.ID.getPreferredName());
        }

        public Builder(DatafeedUpdate config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices;
            this.types = config.types;
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
        }

        public void setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setIndices(List<String> indices) {
            this.indices = indices;
        }

        public void setTypes(List<String> types) {
            this.types = types;
        }

        public void setQueryDelay(TimeValue queryDelay) {
            this.queryDelay = queryDelay;
        }

        public void setFrequency(TimeValue frequency) {
            this.frequency = frequency;
        }

        public void setQuery(QueryBuilder query) {
            this.query = query;
        }

        public void setAggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
        }

        public void setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>(scriptFields);
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
        }

        public void setScrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
        }

        public void setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
        }

        public DatafeedUpdate build() {
            return new DatafeedUpdate(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.types, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.chunkingConfig);
        }
    }
}

