/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.expression.FieldDataValueSource;

final class CountMethodValueSource
extends ValueSource {
    IndexFieldData<?> fieldData;

    CountMethodValueSource(IndexFieldData<?> fieldData) {
        Objects.requireNonNull(fieldData);
        this.fieldData = fieldData;
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicNumericFieldData leafData = (AtomicNumericFieldData)this.fieldData.load(leaf);
        final SortedNumericDoubleValues values = leafData.getDoubleValues();
        return new DoubleDocValues(this){

            public double doubleVal(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    return values.docValueCount();
                }
                return 0.0;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldDataValueSource that = (FieldDataValueSource)((Object)o);
        return this.fieldData.equals(that.fieldData);
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.hashCode();
    }

    public String description() {
        return "count: field(" + this.fieldData.getFieldName() + ")";
    }
}

