/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.time.HaltedClock;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherXContentParser;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.trigger.Trigger;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;
import org.elasticsearch.xpack.watcher.condition.InternalAlwaysCondition;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.none.ExecutableNoneInput;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WatchParser
extends AbstractComponent {
    private final TriggerService triggerService;
    private final ActionRegistry actionRegistry;
    private final InputRegistry inputRegistry;
    private final CryptoService cryptoService;
    private final ExecutableInput defaultInput;
    private final ExecutableCondition defaultCondition;
    private final List<ActionWrapper> defaultActions;
    private final Clock clock;

    public WatchParser(Settings settings, TriggerService triggerService, ActionRegistry actionRegistry, InputRegistry inputRegistry, @Nullable CryptoService cryptoService, Clock clock) {
        super(settings);
        this.triggerService = triggerService;
        this.actionRegistry = actionRegistry;
        this.inputRegistry = inputRegistry;
        this.cryptoService = cryptoService;
        this.defaultInput = new ExecutableNoneInput(this.logger);
        this.defaultCondition = InternalAlwaysCondition.INSTANCE;
        this.defaultActions = Collections.emptyList();
        this.clock = clock;
    }

    public Watch parse(String name, boolean includeStatus, BytesReference source, XContentType xContentType) throws IOException {
        return this.parse(name, includeStatus, false, source, new DateTime(this.clock.millis(), DateTimeZone.UTC), xContentType, false);
    }

    public Watch parse(String name, boolean includeStatus, BytesReference source, DateTime now, XContentType xContentType) throws IOException {
        return this.parse(name, includeStatus, false, source, now, xContentType, false);
    }

    public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, DateTime now, XContentType xContentType, boolean allowRedactedPasswords) throws IOException {
        return this.parse(id, includeStatus, true, source, now, xContentType, allowRedactedPasswords);
    }

    public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, DateTime now, XContentType xContentType) throws IOException {
        return this.parse(id, includeStatus, true, source, now, xContentType, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Watch parse(String id, boolean includeStatus, boolean withSecrets, BytesReference source, DateTime now, XContentType xContentType, boolean allowRedactedPasswords) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("parsing watch [{}] ", (Object)source.utf8ToString());
        }
        try {
            Throwable throwable = null;
            try (StreamInput stream = source.streamInput();){
                Watch watch;
                WatcherXContentParser parser = new WatcherXContentParser(xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream), (Clock)new HaltedClock(now), withSecrets ? this.cryptoService : null, allowRedactedPasswords);
                Throwable throwable2 = null;
                try {
                    parser.nextToken();
                    watch = this.parse(id, includeStatus, (XContentParser)parser);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            WatchParser.$closeResource(throwable2, (AutoCloseable)parser);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                WatchParser.$closeResource(throwable2, (AutoCloseable)parser);
                return watch;
            }
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"could not parse watch [{}]", (Throwable)ioe, (Object[])new Object[]{id});
        }
    }

    public Watch parse(String id, boolean includeStatus, XContentParser parser) throws IOException {
        XContentParser.Token token;
        Trigger trigger = null;
        ExecutableInput input = this.defaultInput;
        ExecutableCondition condition = this.defaultCondition;
        List actions = this.defaultActions;
        ExecutableTransform transform = null;
        TimeValue throttlePeriod = null;
        Map metatdata = null;
        WatchStatus status = null;
        long version = -3L;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == null) {
                throw new ElasticsearchParseException("could not parse watch [{}]. null token", new Object[]{id});
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == null || currentFieldName == null) {
                throw new ElasticsearchParseException("could not parse watch [{}], unexpected token [{}]", new Object[]{id, token});
            }
            if (WatchField.TRIGGER.match(currentFieldName, parser.getDeprecationHandler())) {
                trigger = this.triggerService.parseTrigger(id, parser);
                continue;
            }
            if (WatchField.INPUT.match(currentFieldName, parser.getDeprecationHandler())) {
                input = this.inputRegistry.parse(id, parser);
                continue;
            }
            if (WatchField.CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                condition = this.actionRegistry.getConditionRegistry().parseExecutable(id, parser);
                continue;
            }
            if (WatchField.TRANSFORM.match(currentFieldName, parser.getDeprecationHandler())) {
                transform = this.actionRegistry.getTransformRegistry().parse(id, parser);
                continue;
            }
            if (WatchField.THROTTLE_PERIOD.match(currentFieldName, parser.getDeprecationHandler())) {
                throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (WatchField.THROTTLE_PERIOD_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)WatchField.THROTTLE_PERIOD_HUMAN.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse watch [{}]. failed to parse time value for field [{}]", (Throwable)pe, new Object[]{id, currentFieldName});
                }
            }
            if (WatchField.ACTIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                actions = this.actionRegistry.parseActions(id, parser);
                continue;
            }
            if (WatchField.METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                metatdata = parser.map();
                continue;
            }
            if (WatchField.VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                version = parser.longValue();
                continue;
            }
            if (WatchField.STATUS.match(currentFieldName, parser.getDeprecationHandler())) {
                if (includeStatus) {
                    status = WatchStatus.parse((String)id, (XContentParser)parser, (Clock)this.clock);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            throw new ElasticsearchParseException("could not parse watch [{}]. unexpected field [{}]", new Object[]{id, currentFieldName});
        }
        if (trigger == null) {
            throw new ElasticsearchParseException("could not parse watch [{}]. missing required field [{}]", new Object[]{id, WatchField.TRIGGER.getPreferredName()});
        }
        if (status != null) {
            for (ActionWrapper action : actions) {
                if (status.actionStatus(action.id()) != null) continue;
                throw new ElasticsearchParseException("could not parse watch [{}]. watch status in invalid state. action [{}] status is missing", new Object[]{id, action.id()});
            }
        } else {
            HashMap<String, ActionStatus> actionsStatuses = new HashMap<String, ActionStatus>();
            DateTime now = new DateTime(WatcherXContentParser.clock((XContentParser)parser).millis(), DateTimeZone.UTC);
            for (ActionWrapper action : actions) {
                actionsStatuses.put(action.id(), new ActionStatus(now));
            }
            status = new WatchStatus(now, Collections.unmodifiableMap(actionsStatuses));
        }
        return new Watch(id, trigger, input, condition, transform, throttlePeriod, actions, metatdata, status, version);
    }
}

