/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeRoleMappingStore
extends AbstractComponent
implements UserRoleMapper {
    static final String DOC_TYPE_FIELD = "doc_type";
    static final String DOC_TYPE_ROLE_MAPPING = "role-mapping";
    private static final String ID_PREFIX = "role-mapping_";
    private static final String SECURITY_GENERIC_TYPE = "doc";
    private static final ActionListener<Object> NO_OP_ACTION_LISTENER = new ActionListener<Object>(){

        public void onResponse(Object o) {
        }

        public void onFailure(Exception e) {
        }
    };
    private final Client client;
    private final boolean isTribeNode;
    private final SecurityIndexManager securityIndex;
    private final List<String> realmsToRefresh = new CopyOnWriteArrayList<String>();

    public NativeRoleMappingStore(Settings settings, Client client, SecurityIndexManager securityIndex) {
        super(settings);
        this.client = client;
        this.isTribeNode = XPackClientActionPlugin.isTribeNode((Settings)settings);
        this.securityIndex = securityIndex;
    }

    private String getNameFromId(String id) {
        assert (id.startsWith(ID_PREFIX));
        return id.substring(ID_PREFIX.length());
    }

    private String getIdForName(String name) {
        return ID_PREFIX + name;
    }

    void loadMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        TermQueryBuilder query = QueryBuilders.termQuery((String)DOC_TYPE_FIELD, (String)DOC_TYPE_ROLE_MAPPING);
        Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security");){
            SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setTypes(new String[]{SECURITY_GENERIC_TYPE}).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
            request.indicesOptions().ignoreUnavailable();
            ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, ActionListener.wrap(mappings -> listener.onResponse(mappings.stream().filter(Objects::nonNull).collect(Collectors.toList())), ex -> {
                this.logger.error((Message)new ParameterizedMessage("failed to load role mappings from index [{}] skipping all mappings.", (Object)".security"), (Throwable)ex);
                listener.onResponse(Collections.emptyList());
            })), doc -> this.buildMapping(this.getNameFromId(doc.getId()), doc.getSourceRef()));
        }
    }

    /*
     * Exception decompiling
     */
    private ExpressionRoleMapping buildMapping(String id, BytesReference source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void putRoleMapping(PutRoleMappingRequest request, ActionListener<Boolean> listener) {
        this.modifyMapping(request.getName(), this::innerPutMapping, request, listener);
    }

    public void deleteRoleMapping(DeleteRoleMappingRequest request, ActionListener<Boolean> listener) {
        this.modifyMapping(request.getName(), this::innerDeleteMapping, request, listener);
    }

    private <Request, Result> void modifyMapping(String name, CheckedBiConsumer<Request, ActionListener<Result>, Exception> inner, Request request, ActionListener<Result> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("role-mappings may not be modified using a tribe node"));
        } else if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
        } else {
            try {
                inner.accept(request, (Object)ActionListener.wrap(r -> this.refreshRealms(listener, r), arg_0 -> listener.onFailure(arg_0)));
            }
            catch (Exception e) {
                this.logger.error((Message)new ParameterizedMessage("failed to modify role-mapping [{}]", (Object)name), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private void innerPutMapping(PutRoleMappingRequest request, final ActionListener<Boolean> listener) {
        final ExpressionRoleMapping mapping = request.getMapping();
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            XContentBuilder xContentBuilder;
            try {
                xContentBuilder = mapping.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", SECURITY_GENERIC_TYPE, this.getIdForName(mapping.getName())).setSource(xContentBuilder).setRefreshPolicy(request.getRefreshPolicy())).request()), (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    listener.onResponse((Object)created);
                }

                public void onFailure(Exception e) {
                    NativeRoleMappingStore.this.logger.error((Message)new ParameterizedMessage("failed to put role-mapping [{}]", (Object)mapping.getName()), (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        });
    }

    private void innerDeleteMapping(final DeleteRoleMappingRequest request, final ActionListener<Boolean> listener) throws IOException {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", SECURITY_GENERIC_TYPE, this.getIdForName(request.getName())).setRefreshPolicy(request.getRefreshPolicy())).request()), (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                boolean deleted = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
                listener.onResponse((Object)deleted);
            }

            public void onFailure(Exception e) {
                NativeRoleMappingStore.this.logger.error((Message)new ParameterizedMessage("failed to delete role-mapping [{}]", (Object)request.getName()), (Throwable)e);
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
    }

    public void getRoleMappings(final Set<String> names, final ActionListener<List<ExpressionRoleMapping>> listener) {
        if (names == null || names.isEmpty()) {
            this.getMappings(listener);
        } else {
            this.getMappings(new ActionListener<List<ExpressionRoleMapping>>(){

                public void onResponse(List<ExpressionRoleMapping> mappings) {
                    List filtered = mappings.stream().filter(m -> names.contains(m.getName())).collect(Collectors.toList());
                    listener.onResponse(filtered);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void getMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        if (this.securityIndex.isAvailable()) {
            this.loadMappings(listener);
        } else {
            this.logger.info("The security index is not yet available - no role mappings can be loaded");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Security Index [{}] [exists: {}] [available: {}] [mapping up to date: {}]", (Object)".security", (Object)this.securityIndex.indexExists(), (Object)this.securityIndex.isAvailable(), (Object)this.securityIndex.isMappingUpToDate());
            }
            listener.onResponse(Collections.emptyList());
        }
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        if (!this.securityIndex.indexExists()) {
            this.reportStats(listener, Collections.emptyList());
        } else {
            this.getMappings((ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> this.reportStats(listener, (List<ExpressionRoleMapping>)mappings), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void reportStats(ActionListener<Map<String, Object>> listener, List<ExpressionRoleMapping> mappings) {
        HashMap<String, Number> usageStats = new HashMap<String, Number>();
        usageStats.put("size", mappings.size());
        usageStats.put("enabled", mappings.stream().filter(ExpressionRoleMapping::isEnabled).count());
        listener.onResponse(usageStats);
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.refreshRealms(NO_OP_ACTION_LISTENER, null);
        }
    }

    private <Result> void refreshRealms(ActionListener<Result> listener, Result result) {
        String[] realmNames = this.realmsToRefresh.toArray(new String[this.realmsToRefresh.size()]);
        SecurityClient securityClient = new SecurityClient((ElasticsearchClient)this.client);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((ClearRealmCacheRequest)securityClient.prepareClearRealmCache().realms(realmNames).request()), (ActionListener)ActionListener.wrap(response -> {
            this.logger.debug(() -> new ParameterizedMessage("Cleared cached in realms [{}] due to role mapping change", (Object)Arrays.toString(realmNames)));
            listener.onResponse(result);
        }, ex -> {
            this.logger.warn("Failed to clear cache for realms [{}]", (Object)Arrays.toString(realmNames));
            listener.onFailure(ex);
        }), (arg_0, arg_1) -> ((SecurityClient)securityClient).clearRealmCache(arg_0, arg_1));
    }

    @Override
    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        this.getRoleMappings(null, (ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> {
            ExpressionModel model = user.asModel();
            Stream<ExpressionRoleMapping> stream = mappings.stream().filter(ExpressionRoleMapping::isEnabled).filter(m -> m.getExpression().match(model));
            if (this.logger.isTraceEnabled()) {
                stream = stream.map(m -> {
                    this.logger.trace("User [{}] matches role-mapping [{}] with roles [{}]", (Object)user.getUsername(), (Object)m.getName(), (Object)m.getRoles());
                    return m;
                });
            }
            Set roles = stream.flatMap(m -> m.getRoles().stream()).collect(Collectors.toSet());
            this.logger.debug("Mapping user [{}] to roles [{}]", (Object)user, roles);
            listener.onResponse(roles);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void refreshRealmOnChange(CachingRealm realm) {
        this.realmsToRefresh.add(realm.name());
    }
}

