/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;
    private static final Set<String> RESPONSE_PARAMS;

    public RestClusterStateAction(Settings settings, RestController controller, SettingsFilter settingsFilter) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "cluster_state_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        boolean isAllIndicesOnly;
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterStateRequest.indicesOptions()));
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        if (request.hasParam("metric")) {
            EnumSet<ClusterState.Metric> metrics = ClusterState.Metric.parseString(request.param("metric"), true);
            clusterStateRequest.nodes(metrics.contains((Object)ClusterState.Metric.NODES) || metrics.contains((Object)ClusterState.Metric.MASTER_NODE));
            clusterStateRequest.routingTable(metrics.contains((Object)ClusterState.Metric.ROUTING_TABLE) || metrics.contains((Object)ClusterState.Metric.ROUTING_NODES));
            clusterStateRequest.metaData(metrics.contains((Object)ClusterState.Metric.METADATA));
            clusterStateRequest.blocks(metrics.contains((Object)ClusterState.Metric.BLOCKS));
            clusterStateRequest.customs(metrics.contains((Object)ClusterState.Metric.CUSTOMS));
        }
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestBuilderListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("cluster_name", response.getClusterName().value());
                builder.humanReadableField("compressed_size_in_bytes", "compressed_size", response.getTotalCompressedSize());
                response.getState().toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("metric");
        responseParams.addAll(Settings.FORMAT_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }

    static final class Fields {
        static final String CLUSTER_NAME = "cluster_name";
        static final String CLUSTER_STATE_SIZE = "compressed_size";
        static final String CLUSTER_STATE_SIZE_IN_BYTES = "compressed_size_in_bytes";

        Fields() {
        }
    }
}

