/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;

class RemoveSettingKeyStoreCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<String> arguments;

    RemoveSettingKeyStoreCommand() {
        super("Remove a setting from the keystore");
        this.arguments = this.parser.nonOptions("setting names");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List<String> settings = this.arguments.values(options);
        if (settings.isEmpty()) {
            throw new UserException(64, "Must supply at least one setting to remove");
        }
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        for (String setting : this.arguments.values(options)) {
            if (!keystore.getSettingNames().contains(setting)) {
                throw new UserException(78, "Setting [" + setting + "] does not exist in the keystore.");
            }
            keystore.remove(setting);
        }
        keystore.save(env.configFile(), new char[0]);
    }
}

