/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.upgrade.Upgrade;

public class InternalIndexReindexer<T> {
    private final Client client;
    private final ClusterService clusterService;
    private final Script transformScript;
    private final String[] types;
    private final int version;
    private final Consumer<ActionListener<T>> preUpgrade;
    private final BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade;

    public InternalIndexReindexer(Client client, ClusterService clusterService, int version, Script transformScript, String[] types, Consumer<ActionListener<T>> preUpgrade, BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade) {
        this.client = client;
        this.clusterService = clusterService;
        this.transformScript = transformScript;
        this.types = types;
        this.version = version;
        this.preUpgrade = preUpgrade;
        this.postUpgrade = postUpgrade;
    }

    public void upgrade(TaskId task, String index, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        ParentTaskAssigningClient parentAwareClient = new ParentTaskAssigningClient(this.client, task);
        this.preUpgrade.accept(ActionListener.wrap(t -> this.innerUpgrade(parentAwareClient, index, clusterState, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(response -> this.postUpgrade.accept(t, (ActionListener<TransportResponse.Empty>)ActionListener.wrap(empty -> listener.onResponse(response), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void innerUpgrade(ParentTaskAssigningClient parentAwareClient, String index, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        String newIndex = index + "-" + this.version;
        try {
            this.checkMasterAndDataNodeVersion(clusterState);
            parentAwareClient.admin().indices().prepareCreate(newIndex).execute(ActionListener.wrap(createIndexResponse -> this.setReadOnlyBlock(index, (ActionListener<TransportResponse.Empty>)ActionListener.wrap(setReadOnlyResponse -> this.reindex(parentAwareClient, index, newIndex, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(bulkByScrollResponse -> this.removeReadOnlyBlock(parentAwareClient, index, (ActionListener<UpdateSettingsResponse>)ActionListener.wrap(unsetReadOnlyResponse -> parentAwareClient.admin().indices().prepareAliases().removeIndex(index).addAlias(newIndex, index).execute(ActionListener.wrap(deleteIndexResponse -> listener.onResponse(bulkByScrollResponse), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), e -> this.removeReadOnlyBlock(parentAwareClient, index, (ActionListener<UpdateSettingsResponse>)ActionListener.wrap(unsetReadOnlyResponse -> listener.onFailure(e), e1 -> listener.onFailure(e))))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    private void checkMasterAndDataNodeVersion(ClusterState clusterState) {
        if (clusterState.nodes().getMinNodeVersion().before(Upgrade.UPGRADE_INTRODUCED)) {
            throw new IllegalStateException("All nodes should have at least version [" + Upgrade.UPGRADE_INTRODUCED + "] to upgrade");
        }
    }

    private void removeReadOnlyBlock(ParentTaskAssigningClient parentAwareClient, String index, ActionListener<UpdateSettingsResponse> listener) {
        Settings settings = Settings.builder().put(IndexMetaData.INDEX_READ_ONLY_SETTING.getKey(), false).build();
        parentAwareClient.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).execute(listener);
    }

    private void reindex(ParentTaskAssigningClient parentAwareClient, String index, String newIndex, ActionListener<BulkByScrollResponse> listener) {
        SearchRequest sourceRequest = new SearchRequest(new String[]{index});
        sourceRequest.types(this.types);
        IndexRequest destinationRequest = new IndexRequest(newIndex);
        ReindexRequest reindexRequest = new ReindexRequest(sourceRequest, destinationRequest);
        reindexRequest.setRefresh(true);
        reindexRequest.setScript(this.transformScript);
        parentAwareClient.execute((Action)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, listener);
    }

    private void setReadOnlyBlock(final String index, final ActionListener<TransportResponse.Empty> listener) {
        this.clusterService.submitStateUpdateTask("lock-index-for-upgrade", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                IndexMetaData indexMetaData = currentState.metaData().index(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                if (indexMetaData.getState() != IndexMetaData.State.OPEN) {
                    throw new IllegalStateException("unable to upgrade a closed index[" + index + "]");
                }
                if (currentState.blocks().hasIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK)) {
                    throw new IllegalStateException("unable to upgrade a read-only index[" + index + "]");
                }
                Settings.Builder indexSettings = Settings.builder().put(indexMetaData.getSettings()).put(IndexMetaData.INDEX_READ_ONLY_SETTING.getKey(), true);
                MetaData.Builder metaDataBuilder = MetaData.builder((MetaData)currentState.metaData()).put(IndexMetaData.builder((IndexMetaData)indexMetaData).settings(indexSettings));
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).addIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                return ClusterState.builder((ClusterState)currentState).metaData(metaDataBuilder).blocks(blocks).build();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
            }
        });
    }
}

