/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.job.config.FilterRef;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RuleScope
implements ToXContentObject,
Writeable {
    private final Map<String, FilterRef> scope;

    public static ContextParser<Void, RuleScope> parser(MlParserType parserType) {
        return (p, c) -> {
            Map unparsedScope = p.map();
            if (unparsedScope.isEmpty()) {
                return new RuleScope();
            }
            ConstructingObjectParser<FilterRef, Void> filterRefParser = FilterRef.PARSERS.get((Object)parserType);
            HashMap<String, FilterRef> scope = new HashMap<String, FilterRef>();
            for (Map.Entry entry : unparsedScope.entrySet()) {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                Throwable throwable = null;
                try {
                    builder.map((Map)entry.getValue());
                    XContentParser scopeParser = XContentFactory.xContent((XContentType)builder.contentType()).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Strings.toString((XContentBuilder)builder));
                    Throwable throwable2 = null;
                    try {
                        scope.put((String)entry.getKey(), (FilterRef)filterRefParser.parse(scopeParser, null));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (scopeParser == null) continue;
                        RuleScope.$closeResource(throwable2, (AutoCloseable)scopeParser);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (builder == null) continue;
                    RuleScope.$closeResource(throwable, (AutoCloseable)builder);
                }
            }
            return new RuleScope(scope);
        };
    }

    public RuleScope() {
        this.scope = Collections.emptyMap();
    }

    public RuleScope(Map<String, FilterRef> scope) {
        this.scope = Collections.unmodifiableMap(scope);
    }

    public RuleScope(StreamInput in) throws IOException {
        this.scope = in.readMap(StreamInput::readString, FilterRef::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.scope, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.scope);
    }

    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    public void validate(Set<String> validKeys) {
        Optional<String> invalidKey = this.scope.keySet().stream().filter(k -> !validKeys.contains(k)).findFirst();
        if (invalidKey.isPresent()) {
            if (validKeys.isEmpty()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid detector rule: scope field ''{0}'' is invalid; detector has no available fields for scoping", invalidKey.get()), new Object[0]);
            }
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid detector rule: scope field ''{0}'' is invalid; select from {1}", invalidKey.get(), validKeys), new Object[0]);
        }
    }

    public Set<String> getReferencedFilters() {
        return this.scope.values().stream().map(FilterRef::getFilterId).collect(Collectors.toSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleScope)) {
            return false;
        }
        RuleScope other = (RuleScope)obj;
        return Objects.equals(this.scope, other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class Builder {
        private Map<String, FilterRef> scope = new HashMap<String, FilterRef>();

        public Builder() {
        }

        public Builder(RuleScope otherScope) {
            this.scope = new HashMap<String, FilterRef>(otherScope.scope);
        }

        public Builder exclude(String field, String filterId) {
            this.scope.put(field, new FilterRef(filterId, FilterRef.FilterType.EXCLUDE));
            return this;
        }

        public Builder include(String field, String filterId) {
            this.scope.put(field, new FilterRef(filterId, FilterRef.FilterType.INCLUDE));
            return this;
        }

        public RuleScope build() {
            return new RuleScope(this.scope);
        }
    }
}

