/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativePrivilegeStore
extends AbstractComponent {
    private static final Collector<Tuple<String, String>, ?, Map<String, List<String>>> TUPLES_TO_MAP = Collectors.toMap(Tuple::v1, t -> CollectionUtils.newSingletonArrayList((Object)((String)t.v2())), (a, b) -> {
        a.addAll(b);
        return a;
    });
    private final Client client;
    private final SecurityClient securityClient;
    private final SecurityIndexManager securityIndexManager;

    public NativePrivilegeStore(Settings settings, Client client, SecurityIndexManager securityIndexManager) {
        super(settings);
        this.client = client;
        this.securityClient = new SecurityClient((ElasticsearchClient)client);
        this.securityIndexManager = securityIndexManager;
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        if (applications != null && applications.size() == 1 && names != null && names.size() == 1) {
            this.getPrivilege(Objects.requireNonNull((String)Iterables.get(applications, (int)0)), Objects.requireNonNull((String)Iterables.get(names, (int)0)), (ActionListener<ApplicationPrivilegeDescriptor>)ActionListener.wrap(privilege -> listener.onResponse(privilege == null ? Collections.emptyList() : Collections.singletonList(privilege)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder query;
                TermQueryBuilder typeQuery = QueryBuilders.termQuery((String)ApplicationPrivilegeDescriptor.Fields.TYPE.getPreferredName(), (String)"application-privilege");
                if (NativePrivilegeStore.isEmpty(applications) && NativePrivilegeStore.isEmpty(names)) {
                    query = typeQuery;
                } else if (NativePrivilegeStore.isEmpty(names)) {
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), (Collection)applications));
                } else if (NativePrivilegeStore.isEmpty(applications)) {
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.NAME.getPreferredName(), (Collection)names));
                } else {
                    String[] docIds = (String[])applications.stream().flatMap(a -> names.stream().map(n -> NativePrivilegeStore.toDocId(a, n))).toArray(String[]::new);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{"doc"}).addIds(docIds));
                }
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security");
                Throwable throwable = null;
                try {
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    this.logger.trace(() -> NativePrivilegeStore.lambda$getPrivileges$6(names, (QueryBuilder)query));
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> this.buildPrivilege(hit.getId(), hit.getSourceRef()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignore != null) {
                        NativePrivilegeStore.$closeResource(throwable, (AutoCloseable)ignore);
                    }
                }
            });
        }
    }

    private static boolean isEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty();
    }

    public void getPrivilege(String application, final String name, final ActionListener<ApplicationPrivilegeDescriptor> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((GetRequest)this.client.prepareGet(".security", "doc", NativePrivilegeStore.toDocId(application, name)).request()), (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (response.isExists()) {
                    listener.onResponse((Object)NativePrivilegeStore.this.buildPrivilege(response.getId(), response.getSourceAsBytesRef()));
                } else {
                    listener.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                    NativePrivilegeStore.this.logger.warn((Message)new ParameterizedMessage("failed to load privilege [{}] index not available", (Object)name), (Throwable)e);
                    listener.onResponse(null);
                } else {
                    NativePrivilegeStore.this.logger.error((Message)new ParameterizedMessage("failed to load privilege [{}]", (Object)name), (Throwable)e);
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
    }

    public void putPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                Map<String, List<String>> createdNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.CREATED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                this.clearRolesCache(listener, createdNames);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), privileges.size(), Collections.emptyList());
            for (ApplicationPrivilegeDescriptor privilege : privileges) {
                this.innerPutPrivilege(privilege, refreshPolicy, (ActionListener<IndexResponse>)groupListener);
            }
        });
    }

    private void innerPutPrivilege(ApplicationPrivilegeDescriptor privilege, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        try {
            String name = privilege.getName();
            XContentBuilder xContentBuilder = privilege.toXContent(XContentFactory.jsonBuilder(), true);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", "doc", NativePrivilegeStore.toDocId(privilege.getApplication(), name)).setSource(xContentBuilder).setRefreshPolicy(refreshPolicy)).request()), listener, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        }
        catch (Exception e) {
            this.logger.warn("Failed to put privilege {} - {}", (Object)Strings.toString((ToXContent)privilege), (Object)e.toString());
            listener.onFailure(e);
        }
    }

    public void deletePrivileges(String application, Collection<String> names, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                Map<String, List<String>> deletedNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.DELETED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                this.clearRolesCache(listener, deletedNames);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), names.size(), Collections.emptyList());
            for (String name : names) {
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", "doc", NativePrivilegeStore.toDocId(application, name)).setRefreshPolicy(refreshPolicy)).request()), (ActionListener)groupListener, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
            }
        });
    }

    private <T> void clearRolesCache(final ActionListener<T> listener, final T value) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(value);
            }

            public void onFailure(Exception e) {
                NativePrivilegeStore.this.logger.error("unable to clear role cache", (Throwable)e);
                listener.onFailure((Exception)new ElasticsearchException("clearing the role cache failed. please clear the role cache manually", (Throwable)e, new Object[0]));
            }
        }, (arg_0, arg_1) -> ((SecurityClient)this.securityClient).clearRolesCache(arg_0, arg_1));
    }

    /*
     * Exception decompiling
     */
    private ApplicationPrivilegeDescriptor buildPrivilege(String docId, BytesReference source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Tuple<String, String> nameFromDocId(String docId) {
        String name = docId.substring("application-privilege".length() + 1);
        assert (name != null && name.length() > 0) : "Invalid name '" + name + "'";
        int colon = name.indexOf(58);
        assert (colon > 0) : "Invalid name '" + name + "' (missing colon)";
        return new Tuple((Object)name.substring(0, colon), (Object)name.substring(colon + 1));
    }

    private static String toDocId(String application, String name) {
        return "application-privilege_" + application + ":" + name;
    }

    private static /* synthetic */ Message lambda$getPrivileges$6(Collection names, QueryBuilder query) {
        return new ParameterizedMessage("Searching for privileges [{}] with query [{}]", (Object)names, (Object)Strings.toString((ToXContent)query));
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

