/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.CachingUsernamePasswordRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordRealm;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    private final Cache<String, ListenableFuture<Tuple<AuthenticationResult, UserWithHash>>> cache;
    private final ThreadPool threadPool;
    final Hasher cacheHasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config, ThreadPool threadPool) {
        super(type, config);
        this.cacheHasher = Hasher.resolve((String)((String)CachingUsernamePasswordRealmSettings.CACHE_HASH_ALGO_SETTING.get(config.settings())));
        this.threadPool = threadPool;
        TimeValue ttl = (TimeValue)CachingUsernamePasswordRealmSettings.CACHE_TTL_SETTING.get(config.settings());
        this.cache = ttl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterWrite(ttl).setMaximumWeight((long)((Integer)CachingUsernamePasswordRealmSettings.CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build() : null;
    }

    public final void expire(String username) {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cache.invalidate((Object)username);
        }
    }

    public final void expireAll() {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cache.invalidateAll();
        }
    }

    public final void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult> listener) {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        try {
            if (this.cache == null) {
                this.doAuthenticate(token, listener);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void authenticateWithCache(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        try {
            SetOnce authenticatedUser = new SetOnce();
            AtomicBoolean createdAndStartedFuture = new AtomicBoolean(false);
            ListenableFuture future = (ListenableFuture)this.cache.computeIfAbsent((Object)token.principal(), k -> {
                ListenableFuture created = new ListenableFuture();
                if (!createdAndStartedFuture.compareAndSet(false, true)) {
                    throw new IllegalStateException("something else already started this. how?");
                }
                return created;
            });
            if (createdAndStartedFuture.get()) {
                this.doAuthenticate(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(result -> {
                    if (result.isAuthenticated()) {
                        User user = result.getUser();
                        authenticatedUser.set((Object)user);
                        UserWithHash userWithHash = new UserWithHash(user, token.credentials(), this.cacheHasher);
                        future.onResponse((Object)new Tuple(result, (Object)userWithHash));
                    } else {
                        future.onResponse((Object)new Tuple(result, null));
                    }
                }, arg_0 -> ((ListenableFuture)future).onFailure(arg_0)));
            }
            future.addListener(ActionListener.wrap(tuple -> {
                if (tuple != null) {
                    UserWithHash userWithHash = (UserWithHash)tuple.v2();
                    boolean performedAuthentication = createdAndStartedFuture.get() && userWithHash != null && ((UserWithHash)tuple.v2()).user == authenticatedUser.get();
                    this.handleResult((ListenableFuture<Tuple<AuthenticationResult, UserWithHash>>)future, createdAndStartedFuture.get(), performedAuthentication, token, (Tuple<AuthenticationResult, UserWithHash>)tuple, listener);
                } else {
                    this.handleFailure((ListenableFuture<Tuple<AuthenticationResult, UserWithHash>>)future, createdAndStartedFuture.get(), token, new IllegalStateException("unknown error authenticating"), listener);
                }
            }, e -> this.handleFailure((ListenableFuture<Tuple<AuthenticationResult, UserWithHash>>)future, createdAndStartedFuture.get(), token, (Exception)e, listener)), this.threadPool.executor("generic"), this.threadPool.getThreadContext());
        }
        catch (ExecutionException e2) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"", (Exception)e2));
        }
    }

    private void handleResult(ListenableFuture<Tuple<AuthenticationResult, UserWithHash>> future, boolean createdAndStartedFuture, boolean performedAuthentication, UsernamePasswordToken token, Tuple<AuthenticationResult, UserWithHash> result, ActionListener<AuthenticationResult> listener) {
        AuthenticationResult authResult = (AuthenticationResult)result.v1();
        if (authResult == null) {
            this.cache.invalidate((Object)token.principal(), future);
            this.authenticateWithCache(token, listener);
        } else if (authResult.isAuthenticated()) {
            if (performedAuthentication) {
                listener.onResponse((Object)authResult);
            } else {
                UserWithHash userWithHash = (UserWithHash)result.v2();
                if (userWithHash.verify(token.credentials())) {
                    if (userWithHash.user.enabled()) {
                        User user = userWithHash.user;
                        this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                        listener.onResponse((Object)AuthenticationResult.success((User)user));
                    } else {
                        this.cache.invalidate((Object)token.principal(), future);
                        this.authenticateWithCache(token, listener);
                    }
                } else {
                    this.cache.invalidate((Object)token.principal(), future);
                    this.authenticateWithCache(token, listener);
                }
            }
        } else {
            this.cache.invalidate((Object)token.principal(), future);
            if (createdAndStartedFuture) {
                listener.onResponse((Object)authResult);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
    }

    private void handleFailure(ListenableFuture<Tuple<AuthenticationResult, UserWithHash>> future, boolean createdAndStarted, UsernamePasswordToken token, Exception e, ActionListener<AuthenticationResult> listener) {
        this.cache.invalidate((Object)token.principal(), future);
        if (createdAndStarted) {
            listener.onFailure(e);
        } else {
            this.authenticateWithCache(token, listener);
        }
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        super.usageStats(ActionListener.wrap(stats -> {
            stats.put("cache", Collections.singletonMap("size", this.getCacheSize()));
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected int getCacheSize() {
        return this.cache.count();
    }

    protected abstract void doAuthenticate(UsernamePasswordToken var1, ActionListener<AuthenticationResult> var2);

    public final void lookupUser(String username, ActionListener<User> listener) {
        if (this.cache != null) {
            try {
                ListenableFuture future = (ListenableFuture)this.cache.computeIfAbsent((Object)username, key -> {
                    ListenableFuture created = new ListenableFuture();
                    this.doLookupUser(username, (ActionListener<User>)ActionListener.wrap(user -> {
                        if (user != null) {
                            UserWithHash userWithHash = new UserWithHash((User)user, null, null);
                            created.onResponse((Object)new Tuple(null, (Object)userWithHash));
                        } else {
                            created.onResponse((Object)new Tuple(null, null));
                        }
                    }, arg_0 -> ((ListenableFuture)created).onFailure(arg_0)));
                    return created;
                });
                future.addListener(ActionListener.wrap(tuple -> {
                    if (tuple != null) {
                        if (tuple.v2() == null) {
                            this.cache.invalidate((Object)username, (Object)future);
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)((UserWithHash)tuple.v2()).user);
                        }
                    } else {
                        listener.onResponse(null);
                    }
                }, arg_0 -> listener.onFailure(arg_0)), this.threadPool.executor("generic"), this.threadPool.getThreadContext());
            }
            catch (ExecutionException e) {
                listener.onFailure((Exception)e);
            }
        } else {
            this.doLookupUser(username, listener);
        }
    }

    protected abstract void doLookupUser(String var1, ActionListener<User> var2);

    private static class UserWithHash {
        final User user;
        final char[] hash;

        UserWithHash(User user, SecureString password, Hasher hasher) {
            this.user = Objects.requireNonNull(user);
            this.hash = password == null ? null : hasher.hash(password);
        }

        boolean verify(SecureString password) {
            return this.hash != null && Hasher.verifyHash((SecureString)password, (char[])this.hash);
        }
    }
}

