/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.job.DateHistoGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.HistoGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.TermsGroupConfig;

public class GroupConfig
implements Writeable,
ToXContentObject {
    private static final String NAME = "grouping_config";
    private static final ParseField DATE_HISTO = new ParseField("date_histogram", new String[0]);
    private static final ParseField HISTO = new ParseField("histogram", new String[0]);
    private static final ParseField TERMS = new ParseField("terms", new String[0]);
    private final DateHistoGroupConfig dateHisto;
    private final HistoGroupConfig histo;
    private final TermsGroupConfig terms;
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("grouping_config", Builder::new);

    private GroupConfig(DateHistoGroupConfig dateHisto, @Nullable HistoGroupConfig histo, @Nullable TermsGroupConfig terms) {
        this.dateHisto = Objects.requireNonNull(dateHisto, "A date_histogram group is mandatory");
        this.histo = histo;
        this.terms = terms;
    }

    GroupConfig(StreamInput in) throws IOException {
        this.dateHisto = new DateHistoGroupConfig(in);
        this.histo = (HistoGroupConfig)in.readOptionalWriteable(HistoGroupConfig::new);
        this.terms = (TermsGroupConfig)in.readOptionalWriteable(TermsGroupConfig::new);
    }

    public DateHistoGroupConfig getDateHisto() {
        return this.dateHisto;
    }

    public HistoGroupConfig getHisto() {
        return this.histo;
    }

    public TermsGroupConfig getTerms() {
        return this.terms;
    }

    public Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.dateHisto.getField());
        if (this.histo != null) {
            fields.addAll(this.histo.getAllFields());
        }
        if (this.terms != null) {
            fields.addAll(this.terms.getAllFields());
        }
        return fields;
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        this.dateHisto.validateMappings(fieldCapsResponse, validationException);
        if (this.histo != null) {
            this.histo.validateMappings(fieldCapsResponse, validationException);
        }
        if (this.terms != null) {
            this.terms.validateMappings(fieldCapsResponse, validationException);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(DATE_HISTO.getPreferredName());
        this.dateHisto.toXContent(builder, params);
        builder.endObject();
        if (this.histo != null) {
            builder.startObject(HISTO.getPreferredName());
            this.histo.toXContent(builder, params);
            builder.endObject();
        }
        if (this.terms != null) {
            builder.startObject(TERMS.getPreferredName());
            this.terms.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.dateHisto.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.histo);
        out.writeOptionalWriteable((Writeable)this.terms);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GroupConfig that = (GroupConfig)other;
        return Objects.equals(this.dateHisto, that.dateHisto) && Objects.equals(this.histo, that.histo) && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(this.dateHisto, this.histo, this.terms);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareObject(Builder::setDateHisto, (p, c) -> ((DateHistoGroupConfig.Builder)DateHistoGroupConfig.PARSER.apply(p, c)).build(), DATE_HISTO);
        PARSER.declareObject(Builder::setHisto, (p, c) -> ((HistoGroupConfig.Builder)HistoGroupConfig.PARSER.apply(p, c)).build(), HISTO);
        PARSER.declareObject(Builder::setTerms, (p, c) -> ((TermsGroupConfig.Builder)TermsGroupConfig.PARSER.apply(p, c)).build(), TERMS);
    }

    public static class Builder {
        private DateHistoGroupConfig dateHisto;
        private HistoGroupConfig histo;
        private TermsGroupConfig terms;

        public DateHistoGroupConfig getDateHisto() {
            return this.dateHisto;
        }

        public Builder setDateHisto(DateHistoGroupConfig dateHisto) {
            this.dateHisto = dateHisto;
            return this;
        }

        public HistoGroupConfig getHisto() {
            return this.histo;
        }

        public Builder setHisto(HistoGroupConfig histo) {
            this.histo = histo;
            return this;
        }

        public TermsGroupConfig getTerms() {
            return this.terms;
        }

        public Builder setTerms(TermsGroupConfig terms) {
            this.terms = terms;
            return this;
        }

        public GroupConfig build() {
            if (this.dateHisto == null) {
                throw new IllegalArgumentException("A date_histogram group is mandatory");
            }
            return new GroupConfig(this.dateHisto, this.histo, this.terms);
        }
    }
}

