/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;

public class FlushJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final FlushJobAction INSTANCE = new FlushJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/flush";

    private FlushJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private boolean flushed;
        private Date lastFinalizedBucketEnd;

        public Response() {
            super(null, null);
        }

        public Response(boolean flushed, @Nullable Date lastFinalizedBucketEnd) {
            super(null, null);
            this.flushed = flushed;
            this.lastFinalizedBucketEnd = lastFinalizedBucketEnd;
        }

        public boolean isFlushed() {
            return this.flushed;
        }

        public Date getLastFinalizedBucketEnd() {
            return this.lastFinalizedBucketEnd;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.flushed = in.readBoolean();
            if (in.getVersion().after(Version.V_5_5_0)) {
                this.lastFinalizedBucketEnd = new Date(in.readVLong());
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.flushed);
            if (out.getVersion().after(Version.V_5_5_0)) {
                out.writeVLong(this.lastFinalizedBucketEnd.getTime());
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("flushed", this.flushed);
            if (this.lastFinalizedBucketEnd != null) {
                builder.timeField(FlushAcknowledgement.LAST_FINALIZED_BUCKET_END.getPreferredName(), FlushAcknowledgement.LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.getTime());
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.flushed == response.flushed && Objects.equals(this.lastFinalizedBucketEnd, response.lastFinalizedBucketEnd);
        }

        public int hashCode() {
            return Objects.hash(this.flushed, this.lastFinalizedBucketEnd);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, FlushJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends JobTaskRequest<Request>
    implements ToXContentObject {
        public static final ParseField CALC_INTERIM = new ParseField("calc_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ADVANCE_TIME = new ParseField("advance_time", new String[0]);
        public static final ParseField SKIP_TIME = new ParseField("skip_time", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/flush", Request::new);
        private boolean calcInterim = false;
        private String start;
        private String end;
        private String advanceTime;
        private String skipTime;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(String jobId) {
            super(jobId);
        }

        public boolean getCalcInterim() {
            return this.calcInterim;
        }

        public void setCalcInterim(boolean calcInterim) {
            this.calcInterim = calcInterim;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getAdvanceTime() {
            return this.advanceTime;
        }

        public void setAdvanceTime(String advanceTime) {
            this.advanceTime = advanceTime;
        }

        public String getSkipTime() {
            return this.skipTime;
        }

        public void setSkipTime(String skipTime) {
            this.skipTime = skipTime;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.calcInterim = in.readBoolean();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.advanceTime = in.readOptionalString();
            if (in.getVersion().after(Version.V_5_5_0)) {
                this.skipTime = in.readOptionalString();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.calcInterim);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.advanceTime);
            if (out.getVersion().after(Version.V_5_5_0)) {
                out.writeOptionalString(this.skipTime);
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.calcInterim, this.start, this.end, this.advanceTime, this.skipTime);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && this.calcInterim == other.calcInterim && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.advanceTime, other.advanceTime) && Objects.equals(this.skipTime, other.skipTime);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(CALC_INTERIM.getPreferredName(), this.calcInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.advanceTime != null) {
                builder.field(ADVANCE_TIME.getPreferredName(), this.advanceTime);
            }
            if (this.skipTime != null) {
                builder.field(SKIP_TIME.getPreferredName(), this.skipTime);
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareBoolean(Request::setCalcInterim, CALC_INTERIM);
            PARSER.declareString(Request::setStart, START);
            PARSER.declareString(Request::setEnd, END);
            PARSER.declareString(Request::setAdvanceTime, ADVANCE_TIME);
            PARSER.declareString(Request::setSkipTime, SKIP_TIME);
        }
    }
}

