/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Map;
import org.elasticsearch.xpack.sql.analysis.index.MappingException;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class TextEsField
extends EsField {
    public TextEsField(String name, Map<String, EsField> properties, boolean hasDocValues) {
        super(name, DataType.TEXT, properties, hasDocValues);
    }

    @Override
    public EsField getExactField() {
        EsField field = null;
        for (EsField property : this.getProperties().values()) {
            if (property.getDataType() != DataType.KEYWORD || !property.isExact()) continue;
            if (field != null) {
                throw new MappingException("Multiple exact keyword candidates available for [" + this.getName() + "]; specify which one to use", new Object[0]);
            }
            field = property;
        }
        if (field == null) {
            throw new MappingException("No keyword/multi-field defined exact matches for [" + this.getName() + "]; define one or use MATCH/QUERY instead", new Object[0]);
        }
        return field;
    }

    @Override
    public boolean isExact() {
        return false;
    }
}

