/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.regex;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.LeafExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class LikePattern
extends LeafExpression {
    private final String pattern;
    private final char escape;
    private final String regex;
    private final String wildcard;
    private final String indexNameWildcard;

    public LikePattern(Location location, String pattern, char escape) {
        super(location);
        this.pattern = pattern;
        this.escape = escape;
        this.regex = StringUtils.likeToJavaPattern(pattern, escape);
        this.wildcard = StringUtils.likeToLuceneWildcard(pattern, escape);
        this.indexNameWildcard = StringUtils.likeToIndexWildcard(pattern, escape);
    }

    @Override
    protected NodeInfo<LikePattern> info() {
        return NodeInfo.create(this, LikePattern::new, this.pattern, Character.valueOf(this.escape));
    }

    public String pattern() {
        return this.pattern;
    }

    public char escape() {
        return this.escape;
    }

    public String asJavaRegex() {
        return this.regex;
    }

    public String asLuceneWildcard() {
        return this.wildcard;
    }

    public String asIndexNameWildcard() {
        return this.indexNameWildcard;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern, Character.valueOf(this.escape));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LikePattern other = (LikePattern)obj;
        return Objects.equals(this.pattern, other.pattern) && this.escape == other.escape;
    }
}

