/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.LessThanOrEqual;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class GreaterThanOrEqual
extends BinaryComparison
implements BinaryOperator.Negateable {
    public GreaterThanOrEqual(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<GreaterThanOrEqual> info() {
        return NodeInfo.create(this, GreaterThanOrEqual::new, this.left(), this.right());
    }

    @Override
    protected GreaterThanOrEqual replaceChildren(Expression newLeft, Expression newRight) {
        return new GreaterThanOrEqual(this.location(), newLeft, newRight);
    }

    @Override
    public Object fold() {
        Integer compare = GreaterThanOrEqual.compare(this.left().fold(), this.right().fold());
        return compare != null && compare >= 0;
    }

    @Override
    public LessThanOrEqual swapLeftAndRight() {
        return new LessThanOrEqual(this.location(), this.right(), this.left());
    }

    @Override
    public LessThan negate() {
        return new LessThan(this.location(), this.left(), this.right());
    }

    @Override
    public String symbol() {
        return ">=";
    }
}

