/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;

public abstract class NotificationService<Account>
extends AbstractComponent {
    private final String type;
    private Map<String, Account> accounts;
    private Account defaultAccount;

    public NotificationService(Settings settings, String type, ClusterSettings clusterSettings, List<Setting<?>> pluginSettings) {
        this(settings, type);
        clusterSettings.addSettingsUpdateConsumer(this::reload, pluginSettings);
    }

    NotificationService(Settings settings, String type) {
        super(settings);
        this.type = type;
    }

    public synchronized void reload(Settings settings) {
        Tuple<Map<String, Object>, Object> accounts = this.buildAccounts(settings, this::createAccount);
        this.accounts = Collections.unmodifiableMap((Map)accounts.v1());
        this.defaultAccount = accounts.v2();
    }

    protected abstract Account createAccount(String var1, Settings var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(String name) {
        Account defaultAccount;
        Map<String, Account> accounts;
        NotificationService notificationService = this;
        synchronized (notificationService) {
            accounts = this.accounts;
            defaultAccount = this.defaultAccount;
        }
        Account theAccount = accounts.getOrDefault(name, defaultAccount);
        if (theAccount == null && name == null) {
            throw new IllegalArgumentException("no accounts of type [" + this.type + "] configured. Please set up an account using the [xpack.notification." + this.type + "] settings");
        }
        if (theAccount == null) {
            throw new IllegalArgumentException("no account found for name: [" + name + "]");
        }
        return theAccount;
    }

    private <A> Tuple<Map<String, A>, A> buildAccounts(Settings settings, BiFunction<String, Settings, A> accountFactory) {
        Object defaultAccount;
        Settings accountsSettings = settings.getByPrefix("xpack.notification." + this.type + ".").getAsSettings("account");
        HashMap<String, A> accounts = new HashMap<String, A>();
        for (String name : accountsSettings.names()) {
            Settings accountSettings = accountsSettings.getAsSettings(name);
            A account = accountFactory.apply(name, accountSettings);
            accounts.put(name, account);
        }
        String defaultAccountName = settings.get("xpack.notification." + this.type + ".default_account");
        if (defaultAccountName == null) {
            if (accounts.isEmpty()) {
                defaultAccount = null;
            } else {
                Object account = accounts.values().iterator().next();
                defaultAccount = account;
            }
        } else {
            defaultAccount = accounts.get(defaultAccountName);
            if (defaultAccount == null) {
                throw new SettingsException("could not find default account [" + defaultAccountName + "]");
            }
        }
        return new Tuple(accounts, defaultAccount);
    }
}

