/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DateEsField;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.type.TextEsField;
import org.elasticsearch.xpack.sql.type.UnsupportedEsField;

public abstract class Types {
    public static Map<String, EsField> fromEs(Map<String, Object> asMap) {
        Map props = null;
        if (asMap != null && !asMap.isEmpty()) {
            props = (Map)asMap.get("properties");
        }
        return props == null || props.isEmpty() ? Collections.emptyMap() : Types.startWalking(props);
    }

    private static Map<String, EsField> startWalking(Map<String, Object> mapping) {
        LinkedHashMap<String, EsField> types = new LinkedHashMap<String, EsField>();
        if (mapping == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, Object> entry : mapping.entrySet()) {
            Types.walkMapping(entry.getKey(), entry.getValue(), types);
        }
        return types;
    }

    private static DataType getType(Map<String, Object> content) {
        if (content.containsKey("type")) {
            try {
                return DataType.fromEsType((String)content.get("type").toString());
            }
            catch (IllegalArgumentException ex) {
                return DataType.UNSUPPORTED;
            }
        }
        if (content.containsKey("properties")) {
            return DataType.OBJECT;
        }
        return DataType.UNSUPPORTED;
    }

    private static void walkMapping(String name, Object value, Map<String, EsField> mapping) {
        EsField field;
        if (value instanceof Map) {
            Object fields;
            Map content = (Map)value;
            DataType esDataType = Types.getType(content);
            Map<String, EsField> properties = esDataType == DataType.OBJECT || esDataType == DataType.NESTED ? Types.fromEs(content) : (content.containsKey("fields") ? ((fields = content.get("fields")) instanceof Map ? Types.startWalking((Map)fields) : Collections.emptyMap()) : Collections.emptyMap());
            boolean docValues = Types.boolSetting(content.get("doc_values"), esDataType.defaultDocValues);
            switch (esDataType) {
                case TEXT: {
                    field = new TextEsField(name, properties, docValues);
                    break;
                }
                case KEYWORD: {
                    int length = Types.intSetting(content.get("ignore_above"), esDataType.defaultPrecision);
                    boolean normalized = Strings.hasText((String)Types.textSetting(content.get("normalizer"), null));
                    field = new KeywordEsField(name, properties, docValues, length, normalized);
                    break;
                }
                case DATE: {
                    Object fmt = content.get("format");
                    if (fmt != null) {
                        field = new DateEsField(name, properties, docValues, Strings.delimitedListToStringArray((String)fmt.toString(), (String)"||"));
                        break;
                    }
                    field = new DateEsField(name, properties, docValues, new String[0]);
                    break;
                }
                case UNSUPPORTED: {
                    String type = content.get("type").toString();
                    field = new UnsupportedEsField(name, type);
                    break;
                }
                default: {
                    field = new EsField(name, esDataType, properties, docValues);
                }
            }
        } else {
            throw new IllegalArgumentException("Unrecognized mapping " + value);
        }
        mapping.put(name, field);
    }

    private static String textSetting(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    private static boolean boolSetting(Object value, boolean defaultValue) {
        return value == null ? defaultValue : Booleans.parseBoolean((String)value.toString(), (boolean)defaultValue);
    }

    private static int intSetting(Object value, int defaultValue) {
        return value == null ? defaultValue : Integer.parseInt(value.toString());
    }
}

