/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class Foldables {
    public static <T> T valueOf(Expression e, DataType to) {
        if (e.foldable()) {
            return (T)DataTypeConversion.conversionFor(e.dataType(), to).convert(e.fold());
        }
        throw new SqlIllegalArgumentException("Cannot determine value for {}", e);
    }

    public static Object valueOf(Expression e) {
        if (e.foldable()) {
            return e.fold();
        }
        throw new SqlIllegalArgumentException("Cannot determine value for {}", e);
    }

    public static String stringValueOf(Expression e) {
        return (String)Foldables.valueOf(e, DataType.KEYWORD);
    }

    public static Integer intValueOf(Expression e) {
        return (Integer)Foldables.valueOf(e, DataType.INTEGER);
    }

    public static Long longValueOf(Expression e) {
        return (Long)Foldables.valueOf(e, DataType.LONG);
    }

    public static double doubleValueOf(Expression e) {
        return (Double)Foldables.valueOf(e, DataType.DOUBLE);
    }

    public static <T> List<T> valuesOf(List<Expression> list, DataType to) {
        ArrayList<T> l = new ArrayList<T>(list.size());
        for (Expression e : list) {
            l.add(Foldables.valueOf(e, to));
        }
        return l;
    }

    public static List<Double> doubleValuesOf(List<Expression> list) {
        return Foldables.valuesOf(list, DataType.DOUBLE);
    }
}

