/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class HistoGroupConfig
implements Writeable,
ToXContentFragment {
    private static final String NAME = "histo_group_config";
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("histo_group_config", Builder::new);
    private static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private final long interval;
    private final String[] fields;

    private HistoGroupConfig(long interval, String[] fields) {
        this.interval = interval;
        this.fields = fields;
    }

    HistoGroupConfig(StreamInput in) throws IOException {
        this.interval = in.readVLong();
        this.fields = in.readStringArray();
    }

    public long getInterval() {
        return this.interval;
    }

    public String[] getFields() {
        return this.fields;
    }

    public List<CompositeValuesSourceBuilder<?>> toBuilders() {
        if (this.fields.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.fields).map(f -> {
            HistogramValuesSourceBuilder vsBuilder = new HistogramValuesSourceBuilder(RollupField.formatIndexerAggName(f, "histogram"));
            vsBuilder.interval((double)this.interval);
            vsBuilder.field(f);
            vsBuilder.missingBucket(true);
            return vsBuilder;
        }).collect(Collectors.toList());
    }

    public Map<String, Object> toAggCap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("agg", "histogram");
        map.put(INTERVAL.getPreferredName(), this.interval);
        return map;
    }

    public Map<String, Object> getMetadata() {
        return Collections.singletonMap(RollupField.formatMetaField("interval"), this.interval);
    }

    public Set<String> getAllFields() {
        return Arrays.stream(this.fields).collect(Collectors.toSet());
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Arrays.stream(this.fields).forEach(field -> {
            Map fieldCaps = (Map)fieldCapsResponse.get(field);
            if (fieldCaps != null && !fieldCaps.isEmpty()) {
                fieldCaps.forEach((key, value) -> {
                    if (RollupField.NUMERIC_FIELD_MAPPER_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else {
                        validationException.addValidationError("The field referenced by a histo group must be a [numeric] type, but found " + fieldCaps.keySet().toString() + " for field [" + field + "]");
                    }
                });
            } else {
                validationException.addValidationError("Could not find a [numeric] field with name [" + field + "] in any of the indices matching the index pattern.");
            }
        });
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(INTERVAL.getPreferredName(), this.interval);
        builder.field(FIELDS.getPreferredName(), (Object)this.fields);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.interval);
        out.writeStringArray(this.fields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistoGroupConfig that = (HistoGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.interval, Arrays.hashCode(this.fields));
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareLong(Builder::setInterval, INTERVAL);
        PARSER.declareStringArray(Builder::setFields, FIELDS);
    }

    public static class Builder {
        private long interval = 0L;
        private List<String> fields;

        public long getInterval() {
            return this.interval;
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public Builder setFields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public HistoGroupConfig build() {
            if (this.interval <= 0L) {
                throw new IllegalArgumentException("Parameter [" + INTERVAL.getPreferredName() + "] must be a positive long.");
            }
            if (this.fields == null || this.fields.isEmpty()) {
                throw new IllegalArgumentException("Parameter [" + FIELDS + "] must have at least one value.");
            }
            return new HistoGroupConfig(this.interval, this.fields.toArray(new String[0]));
        }
    }
}

