/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.WeightBuilder;

public class FunctionScoreQueryBuilder
extends AbstractQueryBuilder<FunctionScoreQueryBuilder> {
    public static final String NAME = "function_score";
    static final String MISPLACED_FUNCTION_MESSAGE_PREFIX = "you can either define [functions] array or a single function, not both. ";
    public static final ParseField WEIGHT_FIELD = new ParseField("weight", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField FUNCTIONS_FIELD = new ParseField("functions", new String[0]);
    public static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    public static final ParseField BOOST_MODE_FIELD = new ParseField("boost_mode", new String[0]);
    public static final ParseField MAX_BOOST_FIELD = new ParseField("max_boost", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final CombineFunction DEFAULT_BOOST_MODE = CombineFunction.MULTIPLY;
    public static final FunctionScoreQuery.ScoreMode DEFAULT_SCORE_MODE = FunctionScoreQuery.ScoreMode.MULTIPLY;
    private final QueryBuilder query;
    private float maxBoost = Float.MAX_VALUE;
    private FunctionScoreQuery.ScoreMode scoreMode = DEFAULT_SCORE_MODE;
    private CombineFunction boostMode;
    private Float minScore = null;
    private final FilterFunctionBuilder[] filterFunctionBuilders;

    public FunctionScoreQueryBuilder(QueryBuilder query) {
        this(query, new FilterFunctionBuilder[0]);
    }

    public FunctionScoreQueryBuilder(FilterFunctionBuilder[] filterFunctionBuilders) {
        this((QueryBuilder)new MatchAllQueryBuilder(), filterFunctionBuilders);
    }

    public FunctionScoreQueryBuilder(ScoreFunctionBuilder<?> scoreFunctionBuilder) {
        this((QueryBuilder)new MatchAllQueryBuilder(), new FilterFunctionBuilder[]{new FilterFunctionBuilder(scoreFunctionBuilder)});
    }

    public FunctionScoreQueryBuilder(QueryBuilder query, ScoreFunctionBuilder<?> scoreFunctionBuilder) {
        this(query, new FilterFunctionBuilder[]{new FilterFunctionBuilder(scoreFunctionBuilder)});
    }

    public FunctionScoreQueryBuilder(QueryBuilder query, FilterFunctionBuilder[] filterFunctionBuilders) {
        if (query == null) {
            throw new IllegalArgumentException("function_score: query must not be null");
        }
        if (filterFunctionBuilders == null) {
            throw new IllegalArgumentException("function_score: filters and functions array must not be null");
        }
        for (FilterFunctionBuilder filterFunctionBuilder : filterFunctionBuilders) {
            if (filterFunctionBuilder != null) continue;
            throw new IllegalArgumentException("function_score: each filter and function must not be null");
        }
        this.query = query;
        this.filterFunctionBuilders = filterFunctionBuilders;
    }

    public FunctionScoreQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.filterFunctionBuilders = in.readList(FilterFunctionBuilder::new).toArray(new FilterFunctionBuilder[0]);
        this.maxBoost = in.readFloat();
        this.minScore = in.readOptionalFloat();
        this.boostMode = in.readOptionalWriteable(CombineFunction::readFromStream);
        this.scoreMode = FunctionScoreQuery.ScoreMode.readFromStream(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.query);
        out.writeList(Arrays.asList(this.filterFunctionBuilders));
        out.writeFloat(this.maxBoost);
        out.writeOptionalFloat(this.minScore);
        out.writeOptionalWriteable(this.boostMode);
        this.scoreMode.writeTo(out);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public FilterFunctionBuilder[] filterFunctionBuilders() {
        return this.filterFunctionBuilders;
    }

    public FunctionScoreQueryBuilder scoreMode(FunctionScoreQuery.ScoreMode scoreMode) {
        if (scoreMode == null) {
            throw new IllegalArgumentException("[function_score]  requires 'score_mode' field");
        }
        this.scoreMode = scoreMode;
        return this;
    }

    public FunctionScoreQuery.ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public FunctionScoreQueryBuilder boostMode(CombineFunction combineFunction) {
        if (combineFunction == null) {
            throw new IllegalArgumentException("[function_score]  requires 'boost_mode' field");
        }
        this.boostMode = combineFunction;
        return this;
    }

    public CombineFunction boostMode() {
        return this.boostMode;
    }

    public FunctionScoreQueryBuilder maxBoost(float maxBoost) {
        this.maxBoost = maxBoost;
        return this;
    }

    public float maxBoost() {
        return this.maxBoost;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.query != null) {
            builder.field(QUERY_FIELD.getPreferredName());
            this.query.toXContent(builder, params);
        }
        builder.startArray(FUNCTIONS_FIELD.getPreferredName());
        for (FilterFunctionBuilder filterFunctionBuilder : this.filterFunctionBuilders) {
            filterFunctionBuilder.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(SCORE_MODE_FIELD.getPreferredName(), this.scoreMode.name().toLowerCase(Locale.ROOT));
        if (this.boostMode != null) {
            builder.field(BOOST_MODE_FIELD.getPreferredName(), this.boostMode.name().toLowerCase(Locale.ROOT));
        }
        builder.field(MAX_BOOST_FIELD.getPreferredName(), this.maxBoost);
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public FunctionScoreQueryBuilder setMinScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(FunctionScoreQueryBuilder other) {
        return Objects.equals(this.query, other.query) && Arrays.equals(this.filterFunctionBuilders, other.filterFunctionBuilders) && Objects.equals(this.boostMode, other.boostMode) && Objects.equals(this.scoreMode, other.scoreMode) && Objects.equals(this.minScore, other.minScore) && Objects.equals(Float.valueOf(this.maxBoost), Float.valueOf(other.maxBoost));
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, Arrays.hashCode(this.filterFunctionBuilders), this.boostMode, this.scoreMode, this.minScore, Float.valueOf(this.maxBoost));
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        ScoreFunction[] filterFunctions = new ScoreFunction[this.filterFunctionBuilders.length];
        int i = 0;
        for (FilterFunctionBuilder filterFunctionBuilder : this.filterFunctionBuilders) {
            ScoreFunction scoreFunction = filterFunctionBuilder.getScoreFunction().toFunction(context);
            if (filterFunctionBuilder.getFilter().getName().equals("match_all")) {
                filterFunctions[i++] = scoreFunction;
                continue;
            }
            Query filter = filterFunctionBuilder.getFilter().toQuery(context);
            filterFunctions[i++] = new FunctionScoreQuery.FilterScoreFunction(filter, scoreFunction);
        }
        Query query = this.query.toQuery(context);
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        if (filterFunctions.length == 0) {
            return new FunctionScoreQuery(query, this.minScore, this.maxBoost);
        }
        if (filterFunctions.length == 1 && !(filterFunctions[0] instanceof FunctionScoreQuery.FilterScoreFunction)) {
            CombineFunction combineFunction = this.boostMode;
            if (combineFunction == null) {
                combineFunction = filterFunctions[0].getDefaultScoreCombiner();
            }
            return new FunctionScoreQuery(query, filterFunctions[0], combineFunction, this.minScore, this.maxBoost);
        }
        CombineFunction boostMode = this.boostMode == null ? DEFAULT_BOOST_MODE : this.boostMode;
        return new FunctionScoreQuery(query, this.scoreMode, filterFunctions, boostMode, this.minScore, this.maxBoost);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder queryBuilder = this.query.rewrite(queryRewriteContext);
        FilterFunctionBuilder[] rewrittenBuilders = new FilterFunctionBuilder[this.filterFunctionBuilders.length];
        boolean rewritten = false;
        for (int i = 0; i < rewrittenBuilders.length; ++i) {
            FilterFunctionBuilder rewrite = this.filterFunctionBuilders[i].rewrite(queryRewriteContext);
            rewritten |= rewrite != this.filterFunctionBuilders[i];
            rewrittenBuilders[i] = rewrite;
        }
        if (queryBuilder != this.query || rewritten) {
            FunctionScoreQueryBuilder newQueryBuilder = new FunctionScoreQueryBuilder(queryBuilder, rewrittenBuilders);
            newQueryBuilder.scoreMode = this.scoreMode;
            newQueryBuilder.minScore = this.minScore;
            newQueryBuilder.maxBoost = this.maxBoost;
            newQueryBuilder.boostMode = this.boostMode;
            return newQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        InnerHitContextBuilder.extractInnerHits(this.query(), innerHits);
    }

    public static FunctionScoreQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        QueryBuilder query = null;
        float boost = 1.0f;
        String queryName = null;
        FunctionScoreQuery.ScoreMode scoreMode = DEFAULT_SCORE_MODE;
        float maxBoost = Float.MAX_VALUE;
        Float minScore = null;
        String currentFieldName = null;
        CombineFunction combineFunction = null;
        boolean functionArrayFound = false;
        boolean singleFunctionFound = false;
        String singleFunctionName = null;
        ArrayList<FilterFunctionBuilder> filterFunctionBuilders = new ArrayList<FilterFunctionBuilder>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String errorString;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (query != null) {
                        throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. [query] is already defined.", NAME);
                    }
                    query = FunctionScoreQueryBuilder.parseInnerQueryBuilder(parser);
                    continue;
                }
                if (singleFunctionFound) {
                    throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. already found function [{}], now encountering [{}]. use [functions] array if you want to define several functions.", NAME, singleFunctionName, currentFieldName);
                }
                if (functionArrayFound) {
                    errorString = "already found [functions] array, now encountering [" + currentFieldName + "].";
                    FunctionScoreQueryBuilder.handleMisplacedFunctionsDeclaration(parser.getTokenLocation(), errorString);
                }
                singleFunctionFound = true;
                singleFunctionName = currentFieldName;
                ScoreFunctionBuilder scoreFunction = (ScoreFunctionBuilder)parser.namedObject(ScoreFunctionBuilder.class, currentFieldName, null);
                filterFunctionBuilders.add(new FilterFunctionBuilder(scoreFunction));
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FUNCTIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (singleFunctionFound) {
                        errorString = "already found [" + singleFunctionName + "], now encountering [functions].";
                        FunctionScoreQueryBuilder.handleMisplacedFunctionsDeclaration(parser.getTokenLocation(), errorString);
                    }
                    functionArrayFound = true;
                    currentFieldName = FunctionScoreQueryBuilder.parseFiltersAndFunctions(parser, filterFunctionBuilders);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. array [{}] is not supported", NAME, currentFieldName);
            }
            if (!token.isValue()) continue;
            if (SCORE_MODE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                scoreMode = FunctionScoreQuery.ScoreMode.fromString(parser.text());
                continue;
            }
            if (BOOST_MODE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                combineFunction = CombineFunction.fromString(parser.text());
                continue;
            }
            if (MAX_BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                maxBoost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (MIN_SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                minScore = Float.valueOf(parser.floatValue());
                continue;
            }
            if (singleFunctionFound) {
                throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. already found function [{}], now encountering [{}]. use [functions] array if you want to define several functions.", NAME, singleFunctionName, currentFieldName);
            }
            if (functionArrayFound) {
                errorString = "already found [functions] array, now encountering [" + currentFieldName + "].";
                FunctionScoreQueryBuilder.handleMisplacedFunctionsDeclaration(parser.getTokenLocation(), errorString);
            }
            if (WEIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                filterFunctionBuilders.add(new FilterFunctionBuilder((ScoreFunctionBuilder<?>)new WeightBuilder().setWeight(parser.floatValue())));
                singleFunctionFound = true;
                singleFunctionName = currentFieldName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. field [{}] is not supported", NAME, currentFieldName);
        }
        if (query == null) {
            query = new MatchAllQueryBuilder();
        }
        FunctionScoreQueryBuilder functionScoreQueryBuilder = new FunctionScoreQueryBuilder(query, filterFunctionBuilders.toArray(new FilterFunctionBuilder[filterFunctionBuilders.size()]));
        if (combineFunction != null) {
            functionScoreQueryBuilder.boostMode(combineFunction);
        }
        functionScoreQueryBuilder.scoreMode(scoreMode);
        functionScoreQueryBuilder.maxBoost(maxBoost);
        if (minScore != null) {
            functionScoreQueryBuilder.setMinScore(minScore.floatValue());
        }
        functionScoreQueryBuilder.boost(boost);
        functionScoreQueryBuilder.queryName(queryName);
        return functionScoreQueryBuilder;
    }

    private static void handleMisplacedFunctionsDeclaration(XContentLocation contentLocation, String errorString) {
        throw new ParsingException(contentLocation, "failed to parse [{}] query. [{}]", NAME, MISPLACED_FUNCTION_MESSAGE_PREFIX + errorString);
    }

    private static String parseFiltersAndFunctions(XContentParser parser, List<FilterFunctionBuilder> filterFunctionBuilders) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            QueryBuilder filter = null;
            ScoreFunctionBuilder scoreFunction = null;
            Float functionWeight = null;
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}]. malformed query, expected a [{}] while parsing functions but got a [{}] instead", XContentParser.Token.START_OBJECT, token, NAME);
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (FILTER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        filter = FunctionScoreQueryBuilder.parseInnerQueryBuilder(parser);
                        continue;
                    }
                    if (scoreFunction != null) {
                        throw new ParsingException(parser.getTokenLocation(), "failed to parse function_score functions. already found [{}], now encountering [{}].", scoreFunction.getName(), currentFieldName);
                    }
                    scoreFunction = (ScoreFunctionBuilder)parser.namedObject(ScoreFunctionBuilder.class, currentFieldName, null);
                    continue;
                }
                if (!token.isValue()) continue;
                if (WEIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    functionWeight = Float.valueOf(parser.floatValue());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. field [{}] is not supported", NAME, currentFieldName);
            }
            if (functionWeight != null) {
                if (scoreFunction == null) {
                    scoreFunction = new WeightBuilder().setWeight(functionWeight.floatValue());
                } else {
                    scoreFunction.setWeight(functionWeight.floatValue());
                }
            }
            if (filter == null) {
                filter = new MatchAllQueryBuilder();
            }
            if (scoreFunction == null) {
                throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. an entry in functions list is missing a function.", NAME);
            }
            filterFunctionBuilders.add(new FilterFunctionBuilder(filter, scoreFunction));
        }
        return currentFieldName;
    }

    public static class FilterFunctionBuilder
    implements ToXContentObject,
    Writeable {
        private final QueryBuilder filter;
        private final ScoreFunctionBuilder<?> scoreFunction;

        public FilterFunctionBuilder(ScoreFunctionBuilder<?> scoreFunctionBuilder) {
            this(new MatchAllQueryBuilder(), scoreFunctionBuilder);
        }

        public FilterFunctionBuilder(QueryBuilder filter, ScoreFunctionBuilder<?> scoreFunction) {
            if (filter == null) {
                throw new IllegalArgumentException("function_score: filter must not be null");
            }
            if (scoreFunction == null) {
                throw new IllegalArgumentException("function_score: function must not be null");
            }
            this.filter = filter;
            this.scoreFunction = scoreFunction;
        }

        public FilterFunctionBuilder(StreamInput in) throws IOException {
            this.filter = in.readNamedWriteable(QueryBuilder.class);
            this.scoreFunction = in.readNamedWriteable(ScoreFunctionBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable(this.filter);
            out.writeNamedWriteable(this.scoreFunction);
        }

        public QueryBuilder getFilter() {
            return this.filter;
        }

        public ScoreFunctionBuilder<?> getScoreFunction() {
            return this.scoreFunction;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FILTER_FIELD.getPreferredName());
            this.filter.toXContent(builder, params);
            this.scoreFunction.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.scoreFunction);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FilterFunctionBuilder that = (FilterFunctionBuilder)obj;
            return Objects.equals(this.filter, that.filter) && Objects.equals(this.scoreFunction, that.scoreFunction);
        }

        public FilterFunctionBuilder rewrite(QueryRewriteContext context) throws IOException {
            QueryBuilder rewrite = this.filter.rewrite(context);
            if (rewrite != this.filter) {
                return new FilterFunctionBuilder(rewrite, this.scoreFunction);
            }
            return this;
        }
    }
}

