/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.SecretKeyFactory;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.xpack.core.XPackSettings;

public class PasswordHashingAlgorithmBootstrapCheck
implements BootstrapCheck {
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        String selectedAlgorithm = (String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(context.settings);
        if (selectedAlgorithm.toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            try {
                SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
            }
            catch (NoSuchAlgorithmException e) {
                String errorMessage = String.format(Locale.ROOT, "Support for PBKDF2WithHMACSHA512 must be available in order to use any of the PBKDF2 algorithms for the [%s] setting.", XPackSettings.PASSWORD_HASHING_ALGORITHM.getKey());
                return BootstrapCheck.BootstrapCheckResult.failure((String)errorMessage);
            }
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

