/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;

public class TransportGetRollupIndexCapsAction
extends HandledTransportAction<GetRollupIndexCapsAction.Request, GetRollupIndexCapsAction.Response> {
    private final ClusterService clusterService;

    @Inject
    public TransportGetRollupIndexCapsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/xpack/rollup/get/index/caps", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetRollupIndexCapsAction.Request::new);
        this.clusterService = clusterService;
    }

    protected void doExecute(GetRollupIndexCapsAction.Request request, ActionListener<GetRollupIndexCapsAction.Response> listener) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver(this.clusterService.getSettings());
        String[] indices = resolver.concreteIndexNames(this.clusterService.state(), request.indicesOptions(), request.indices());
        Map<String, RollableIndexCaps> allCaps = TransportGetRollupIndexCapsAction.getCapsByRollupIndex(Arrays.asList(indices), (ImmutableOpenMap<String, IndexMetaData>)this.clusterService.state().getMetaData().indices());
        listener.onResponse((Object)new GetRollupIndexCapsAction.Response(allCaps));
    }

    static Map<String, RollableIndexCaps> getCapsByRollupIndex(List<String> resolvedIndexNames, ImmutableOpenMap<String, IndexMetaData> indices) {
        TreeMap<String, RollableIndexCaps> allCaps = new TreeMap<String, RollableIndexCaps>();
        StreamSupport.stream(indices.spliterator(), false).filter(entry -> resolvedIndexNames.contains(entry.key)).forEach(entry -> TransportGetRollupCapsAction.findRollupIndexCaps((String)entry.key, (IndexMetaData)entry.value).ifPresent(cap -> cap.getJobCaps().forEach(jobCap -> {
            RollableIndexCaps indexCaps = (RollableIndexCaps)allCaps.get(jobCap.getRollupIndex());
            if (indexCaps == null) {
                indexCaps = new RollableIndexCaps(jobCap.getRollupIndex());
            }
            indexCaps.addJobCap(jobCap);
            allCaps.put(jobCap.getRollupIndex(), indexCaps);
        })));
        return allCaps;
    }
}

