/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperMergeValidator;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static ObjectHashSet<String> META_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_all", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl", "_ignored"});
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(MapperService.class));
    private final IndexAnalyzers indexAnalyzers;
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile Map<String, DocumentMapper> mappers = Collections.emptyMap();
    private volatile FieldTypeLookup fieldTypes;
    private volatile Map<String, ObjectMapper> fullPathObjectMappers = Collections.emptyMap();
    private boolean hasNested = false;
    private boolean allEnabled = false;
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private volatile Map<String, MappedFieldType> unmappedFieldTypes = Collections.emptyMap();
    private volatile Set<String> parentTypes = Collections.emptySet();
    final MapperRegistry mapperRegistry;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier) {
        super(indexSettings);
        this.indexAnalyzers = indexAnalyzers;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(indexSettings, this, indexAnalyzers, xContentRegistry, similarityService, mapperRegistry, queryShardContextSupplier);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), p -> p.indexAnalyzer());
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), p -> p.searchAnalyzer());
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer(), p -> p.searchQuoteAnalyzer());
        this.mapperRegistry = mapperRegistry;
        if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_rc1)) {
            if (INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings())) {
                DEPRECATION_LOGGER.deprecated("Setting " + INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " is deprecated since indices may not have more than one type anymore.", new Object[0]);
            }
            this.dynamic = true;
        } else {
            this.dynamic = this.indexSettings.getValue(INDEX_MAPPER_DYNAMIC_SETTING);
        }
        this.defaultMappingSource = "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("using dynamic[{}], default mapping source[{}]", (Object)this.dynamic, (Object)this.defaultMappingSource);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("using dynamic[{}]", (Object)this.dynamic);
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public boolean allEnabled() {
        return this.allEnabled;
    }

    public Iterable<DocumentMapper> docMappers(boolean includingDefaultMapping) {
        return () -> {
            Collection documentMappers = includingDefaultMapping ? this.mappers.values() : (Collection)this.mappers.values().stream().filter(mapper -> !DEFAULT_MAPPING.equals(mapper.type())).collect(Collectors.toList());
            return Collections.unmodifiableCollection(documentMappers).iterator();
        };
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws Exception {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetaData indexMetaData) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        assert (indexMetaData.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + indexMetaData.getIndex();
        HashSet<String> existingMappers = new HashSet<String>(this.mappers.keySet());
        try {
            updatedEntries = this.internalMerge(indexMetaData, MergeReason.MAPPING_RECOVERY, true, true);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        boolean requireRefresh = false;
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            String mappingType = documentMapper.type();
            CompressedXContent incomingMappingSource = indexMetaData.mapping(mappingType).source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
            }
            if (this.documentMapper(mappingType).mappingSource().equals(incomingMappingSource)) continue;
            this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)incomingMappingSource, (Object)this.documentMapper(mappingType).mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason, boolean updateAllTypes) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(entry.getValue()))));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        this.internalMerge(mappingSourcesCompressed, reason, updateAllTypes);
    }

    public void merge(IndexMetaData indexMetaData, MergeReason reason, boolean updateAllTypes) {
        this.internalMerge(indexMetaData, reason, updateAllTypes, false);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason, boolean updateAllTypes) {
        return this.internalMerge(Collections.singletonMap(type, mappingSource), reason, updateAllTypes).get(type);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(IndexMetaData indexMetaData, MergeReason reason, boolean updateAllTypes, boolean onlyUpdateIfNeeded) {
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        for (ObjectCursor cursor : indexMetaData.getMappings().values()) {
            MappingMetaData mappingMetaData = (MappingMetaData)cursor.value;
            if (onlyUpdateIfNeeded) {
                DocumentMapper existingMapper = this.documentMapper(mappingMetaData.type());
                if (existingMapper != null && mappingMetaData.source().equals(existingMapper.mappingSource())) continue;
                map.put(mappingMetaData.type(), mappingMetaData.source());
                continue;
            }
            map.put(mappingMetaData.type(), mappingMetaData.source());
        }
        return this.internalMerge(map, reason, updateAllTypes);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(Map<String, CompressedXContent> mappings, MergeReason reason, boolean updateAllTypes) {
        DocumentMapper defaultMapper = null;
        String defaultMappingSource = null;
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                defaultMapper = this.documentParser.parse(DEFAULT_MAPPING, mappings.get(DEFAULT_MAPPING));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
            try {
                defaultMappingSource = mappings.get(DEFAULT_MAPPING).string();
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("failed to un-compress", e);
            }
        }
        String defaultMappingSourceOrLastStored = defaultMappingSource != null ? defaultMappingSource : this.defaultMappingSource;
        ArrayList<DocumentMapper> documentMappers = new ArrayList<DocumentMapper>();
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (type.equals(DEFAULT_MAPPING)) continue;
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && !this.mappers.containsKey(type);
            try {
                DocumentMapper documentMapper = this.documentParser.parse(type, entry.getValue(), applyDefault ? defaultMappingSourceOrLastStored : null);
                documentMappers.add(documentMapper);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        return this.internalMerge(defaultMapper, defaultMappingSource, documentMappers, reason, updateAllTypes);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [" + SINGLE_MAPPING_NAME + "]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized Map<String, DocumentMapper> internalMerge(@Nullable DocumentMapper defaultMapper, @Nullable String defaultMappingSource, List<DocumentMapper> documentMappers, MergeReason reason, boolean updateAllTypes) {
        boolean hasNested = this.hasNested;
        boolean allEnabled = this.allEnabled;
        Map<String, ObjectMapper> fullPathObjectMappers = this.fullPathObjectMappers;
        FieldTypeLookup fieldTypes = this.fieldTypes;
        Set<String> parentTypes = this.parentTypes;
        Map<String, DocumentMapper> mappers = new HashMap<String, DocumentMapper>(this.mappers);
        Map<String, DocumentMapper> results = new LinkedHashMap<String, DocumentMapper>(documentMappers.size() + 1);
        if (defaultMapper != null) {
            if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1) && reason == MergeReason.MAPPING_UPDATE) {
                DEPRECATION_LOGGER.deprecated("[_default_] mapping is deprecated since it is not useful anymore now that indexes cannot have more than one type", new Object[0]);
            }
            assert (defaultMapper.type().equals(DEFAULT_MAPPING));
            mappers.put(DEFAULT_MAPPING, defaultMapper);
            results.put(DEFAULT_MAPPING, defaultMapper);
        }
        if (this.indexSettings.isSingleType()) {
            HashSet actualTypes = new HashSet(mappers.keySet());
            documentMappers.forEach(mapper -> actualTypes.add(mapper.type()));
            actualTypes.remove(DEFAULT_MAPPING);
            if (actualTypes.size() > 1) {
                throw new IllegalArgumentException("Rejecting mapping update to [" + this.index().getName() + "] as the final mapping would have more than 1 type: " + actualTypes);
            }
        }
        for (DocumentMapper documentMapper : documentMappers) {
            MapperService.validateTypeName(documentMapper.type());
            if (documentMapper.type().equals(documentMapper.parentFieldMapper().type())) {
                throw new IllegalArgumentException("The [_parent.type] option can't point to the same type");
            }
            DocumentMapper oldMapper = (DocumentMapper)mappers.get(documentMapper.type());
            DocumentMapper newMapper = oldMapper != null ? oldMapper.merge(documentMapper.mapping(), updateAllTypes) : documentMapper;
            ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            ArrayList<FieldAliasMapper> fieldAliasMappers = new ArrayList<FieldAliasMapper>();
            Collections.addAll(fieldMappers, newMapper.mapping().metadataMappers);
            MapperUtils.collect(newMapper.mapping().root(), objectMappers, fieldMappers, fieldAliasMappers);
            MapperMergeValidator.validateMapperStructure(newMapper.type(), objectMappers, fieldMappers, fieldAliasMappers, fullPathObjectMappers, fieldTypes, updateAllTypes);
            this.checkPartitionedIndexConstraints(newMapper);
            fieldTypes = fieldTypes.copyAndAddAll(newMapper.type(), fieldMappers, fieldAliasMappers, updateAllTypes);
            for (ObjectMapper objectMapper : objectMappers) {
                if (fullPathObjectMappers == this.fullPathObjectMappers) {
                    fullPathObjectMappers = new HashMap<String, ObjectMapper>(this.fullPathObjectMappers);
                }
                fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
                if (!objectMapper.nested().isNested()) continue;
                hasNested = true;
            }
            MapperMergeValidator.validateFieldReferences(this.indexSettings, fieldMappers, fieldAliasMappers, fullPathObjectMappers, fieldTypes);
            if (reason == MergeReason.MAPPING_UPDATE) {
                this.checkTotalFieldsLimit(objectMappers.size() + fieldMappers.size() + fieldAliasMappers.size());
            }
            if (oldMapper == null && newMapper.parentFieldMapper().active()) {
                if (parentTypes == this.parentTypes) {
                    parentTypes = new HashSet<String>(this.parentTypes);
                }
                parentTypes.add(documentMapper.parentFieldMapper().type());
            }
            allEnabled |= documentMapper.allFieldMapper().enabled();
            results.put(newMapper.type(), newMapper);
            mappers.put(newMapper.type(), newMapper);
        }
        if (reason == MergeReason.MAPPING_UPDATE) {
            this.checkNestedFieldsLimit(fullPathObjectMappers);
            this.checkDepthLimit(fullPathObjectMappers.keySet());
        }
        MapperService.checkIndexSortCompatibility(this.indexSettings.getIndexSortConfig(), hasNested);
        for (Map.Entry entry : mappers.entrySet()) {
            DocumentMapper documentMapper;
            DocumentMapper updatedDocumentMapper;
            if (((String)entry.getKey()).equals(DEFAULT_MAPPING) || (updatedDocumentMapper = (documentMapper = (DocumentMapper)entry.getValue()).updateFieldType(fieldTypes.fullNameToFieldType)) == documentMapper) continue;
            entry.setValue(updatedDocumentMapper);
            if (!results.containsKey(updatedDocumentMapper.type())) continue;
            results.put(updatedDocumentMapper.type(), updatedDocumentMapper);
        }
        mappers = Collections.unmodifiableMap(mappers);
        results = Collections.unmodifiableMap(results);
        if (fullPathObjectMappers != this.fullPathObjectMappers) {
            fullPathObjectMappers = Collections.unmodifiableMap(fullPathObjectMappers);
        }
        if (parentTypes != this.parentTypes) {
            parentTypes = Collections.unmodifiableSet(parentTypes);
        }
        if (defaultMappingSource != null) {
            this.defaultMappingSource = defaultMappingSource;
        }
        this.mappers = mappers;
        this.fieldTypes = fieldTypes;
        this.hasNested = hasNested;
        this.fullPathObjectMappers = fullPathObjectMappers;
        this.parentTypes = parentTypes;
        this.allEnabled = allEnabled;
        assert (this.assertMappersShareSameFieldType());
        assert (results.values().stream().allMatch(this::assertSerialization));
        return results;
    }

    private boolean assertMappersShareSameFieldType() {
        for (DocumentMapper mapper : this.docMappers(false)) {
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            Collections.addAll(fieldMappers, mapper.mapping().metadataMappers);
            MapperUtils.collect(mapper.root(), new ArrayList<ObjectMapper>(), fieldMappers, new ArrayList<FieldAliasMapper>());
            for (FieldMapper fieldMapper : fieldMappers) {
                assert (fieldMapper.fieldType() == this.fieldTypes.get(fieldMapper.name())) : fieldMapper.name();
            }
        }
        return true;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    private void checkNestedFieldsLimit(Map<String, ObjectMapper> fullPathObjectMappers) {
        long allowedNestedFields = this.indexSettings.getValue(INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING);
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : fullPathObjectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > allowedNestedFields) {
            throw new IllegalArgumentException("Limit of nested fields [" + allowedNestedFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkTotalFieldsLimit(long totalMappers) {
        long allowedTotalFields = this.indexSettings.getValue(INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        if (allowedTotalFields < totalMappers) {
            throw new IllegalArgumentException("Limit of total fields [" + allowedTotalFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkDepthLimit(Collection<String> objectPaths) {
        long maxDepth = this.indexSettings.getValue(INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        for (String objectPath : objectPaths) {
            this.checkDepthLimit(objectPath, maxDepth);
        }
    }

    private void checkDepthLimit(String objectPath, long maxDepth) {
        int numDots = 0;
        for (int i = 0; i < objectPath.length(); ++i) {
            if (objectPath.charAt(i) != '.') continue;
            ++numDots;
        }
        int depth = numDots + 2;
        if ((long)depth > maxDepth) {
            throw new IllegalArgumentException("Limit of mapping depth [" + maxDepth + "] in index [" + this.index().getName() + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkPartitionedIndexConstraints(DocumentMapper newMapper) {
        if (this.indexSettings.getIndexMetaData().isRoutingPartitionedIndex()) {
            if (newMapper.parentFieldMapper().active()) {
                throw new IllegalArgumentException("mapping type name [" + newMapper.type() + "] cannot have a _parent field for the partitioned index [" + this.indexSettings.getIndex().getName() + "]");
            }
            if (!newMapper.routingFieldMapper().required()) {
                throw new IllegalArgumentException("mapping type [" + newMapper.type() + "] must have routing required for partitioned index [" + this.indexSettings.getIndex().getName() + "]");
            }
        }
    }

    private static void checkIndexSortCompatibility(IndexSortConfig sortConfig, boolean hasNested) {
        if (sortConfig.hasIndexSort() && hasNested) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public Collection<String> types() {
        HashSet<String> types = new HashSet<String>(this.mappers.keySet());
        types.remove(DEFAULT_MAPPING);
        return Collections.unmodifiableSet(types);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index(), (Throwable)new IllegalStateException("trying to auto create mapping, but dynamic mapping is disabled"), type);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singletonList(pattern);
        }
        return this.fieldTypes.simpleMatchToFullName(pattern);
    }

    public Iterable<MappedFieldType> fieldTypes() {
        return this.fieldTypes;
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.fullPathObjectMappers.get(name);
    }

    public MappedFieldType unmappedFieldType(String type) {
        MappedFieldType fieldType;
        if (type.equals("string")) {
            this.deprecationLogger.deprecated("[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((fieldType = this.unmappedFieldTypes.get(type)) == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext(type);
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?, ?> builder = typeParser.parse("__anonymous_" + type, Collections.emptyMap(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            HashMap<String, MappedFieldType> newUnmappedFieldTypes = new HashMap<String, MappedFieldType>(this.unmappedFieldTypes);
            newUnmappedFieldTypes.put(type, fieldType);
            this.unmappedFieldTypes = Collections.unmodifiableMap(newUnmappedFieldTypes);
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public Set<String> getParentTypes() {
        return this.parentTypes;
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains((Object)fieldName);
    }

    public static String[] getAllMetaFields() {
        return (String[])META_FIELDS.toArray(String.class);
    }

    public Term createUidTerm(String type, String id) {
        if (!this.hasMapping(type)) {
            return null;
        }
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1)) {
            assert (this.indexSettings.isSingleType());
            return new Term("_id", Uid.encodeId(id));
        }
        if (this.indexSettings.isSingleType()) {
            return new Term("_id", id);
        }
        return new Term("_uid", Uid.createUidAsBytes(type, id));
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fullName(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE,
        MAPPING_RECOVERY;

    }
}

