/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.xpack.sql.capabilities.Unresolvable;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Exists;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.plan.logical.Aggregate;
import org.elasticsearch.xpack.sql.plan.logical.Distinct;
import org.elasticsearch.xpack.sql.plan.logical.Filter;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.OrderBy;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

abstract class Verifier {
    Verifier() {
    }

    private static Failure fail(Node<?> source, String message, Object ... args) {
        return new Failure(source, String.format(Locale.ROOT, message, args));
    }

    static Collection<Failure> verify(LogicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachUp(p -> {
            if (p.analyzed()) {
                return;
            }
            if (!p.childrenResolved()) {
                return;
            }
            LinkedHashSet<Failure> localFailures = new LinkedHashSet<Failure>();
            if (p instanceof Unresolvable) {
                localFailures.add(Verifier.fail(p, ((Unresolvable)((Object)p)).unresolvedMessage(), new Object[0]));
            } else if (p instanceof Distinct) {
                localFailures.add(Verifier.fail(p, "SELECT DISTINCT is not yet supported", new Object[0]));
            } else {
                p.forEachExpressions(e -> {
                    if (e.resolved()) {
                        return;
                    }
                    e.forEachUp(ae -> {
                        if (!ae.childrenResolved()) {
                            return;
                        }
                        if (ae instanceof Unresolvable) {
                            UnresolvedAttribute ua;
                            if (ae instanceof UnresolvedAttribute && !(ua = (UnresolvedAttribute)ae).customMessage()) {
                                boolean useQualifier = ua.qualifier() != null;
                                ArrayList<String> potentialMatches = new ArrayList<String>();
                                for (Attribute a : p.intputSet()) {
                                    String nameCandidate;
                                    String string = nameCandidate = useQualifier ? a.qualifiedName() : a.name();
                                    if (a.dataType() == DataType.UNSUPPORTED || !a.dataType().isPrimitive()) continue;
                                    potentialMatches.add(nameCandidate);
                                }
                                List<String> matches = StringUtils.findSimilar(ua.qualifiedName(), potentialMatches);
                                if (!matches.isEmpty()) {
                                    ae = ua.withUnresolvedMessage(UnresolvedAttribute.errorMessage(ua.qualifiedName(), matches));
                                }
                            }
                            localFailures.add(Verifier.fail(ae, ((Unresolvable)((Object)ae)).unresolvedMessage(), new Object[0]));
                            return;
                        }
                        if (ae.typeResolved().unresolved()) {
                            localFailures.add(Verifier.fail(ae, ae.typeResolved().message(), new Object[0]));
                        } else if (ae instanceof Exists) {
                            localFailures.add(Verifier.fail(ae, "EXISTS is not yet supported", new Object[0]));
                        }
                    });
                });
            }
            failures.addAll(localFailures);
        });
        if (failures.isEmpty()) {
            Map<String, Function> resolvedFunctions = Functions.collectFunctions(plan);
            LinkedHashSet groupingFailures = new LinkedHashSet();
            plan.forEachDown(p -> {
                if (p.analyzed()) {
                    return;
                }
                if (!p.childrenResolved()) {
                    return;
                }
                LinkedHashSet<Failure> localFailures = new LinkedHashSet<Failure>();
                if (!groupingFailures.contains(p)) {
                    Verifier.checkGroupBy(p, localFailures, resolvedFunctions, groupingFailures);
                }
                Verifier.checkForScoreInsideFunctions(p, localFailures);
                Verifier.checkNestedUsedInGroupByOrHaving(p, localFailures);
                if (localFailures.isEmpty()) {
                    p.setAnalyzed();
                }
                failures.addAll(localFailures);
            });
        }
        return failures;
    }

    private static boolean checkGroupBy(LogicalPlan p, Set<Failure> localFailures, Map<String, Function> resolvedFunctions, Set<LogicalPlan> groupingFailures) {
        return Verifier.checkGroupByAgg(p, localFailures, groupingFailures, resolvedFunctions) && Verifier.checkGroupByOrder(p, localFailures, groupingFailures, resolvedFunctions) && Verifier.checkGroupByHaving(p, localFailures, groupingFailures, resolvedFunctions);
    }

    private static boolean checkGroupByOrder(LogicalPlan p, Set<Failure> localFailures, Set<LogicalPlan> groupingFailures, Map<String, Function> functions) {
        OrderBy o;
        if (p instanceof OrderBy && (o = (OrderBy)p).child() instanceof Aggregate) {
            Aggregate a = (Aggregate)o.child();
            LinkedHashMap missing = new LinkedHashMap();
            o.order().forEach(oe -> {
                Expression e = oe.child();
                if (Functions.isAggregate(e)) {
                    missing.put(e, oe);
                    return;
                }
                if (Expressions.anyMatch(a.groupings(), g -> e.semanticEquals(e instanceof Attribute ? Expressions.attribute(g) : g))) {
                    return;
                }
                missing.put(e, oe);
            });
            if (!missing.isEmpty()) {
                String plural = missing.size() > 1 ? "s" : "";
                localFailures.add(Verifier.fail((Node)missing.values().iterator().next(), "Cannot order by non-grouped column" + plural + " %s, expected %s", Expressions.names(missing.keySet()), Expressions.names(a.groupings())));
                groupingFailures.add(a);
                return false;
            }
        }
        return true;
    }

    private static boolean checkGroupByHaving(LogicalPlan p, Set<Failure> localFailures, Set<LogicalPlan> groupingFailures, Map<String, Function> functions) {
        Filter f;
        if (p instanceof Filter && (f = (Filter)p).child() instanceof Aggregate) {
            Aggregate a = (Aggregate)f.child();
            LinkedHashMap missing = new LinkedHashMap();
            Expression condition = f.condition();
            condition.collectFirstChildren(c -> Verifier.checkGroupByHavingHasOnlyAggs(c, condition, missing, functions));
            if (!missing.isEmpty()) {
                String plural = missing.size() > 1 ? "s" : "";
                localFailures.add(Verifier.fail(condition, "Cannot filter HAVING on non-aggregate" + plural + " %s; consider using WHERE instead", Expressions.names(missing.keySet())));
                groupingFailures.add(a);
                return false;
            }
        }
        return true;
    }

    private static boolean checkGroupByHavingHasOnlyAggs(Expression e, Node<?> source, Map<Expression, Node<?>> missing, Map<String, Function> functions) {
        if (e instanceof FunctionAttribute) {
            FunctionAttribute fa = (FunctionAttribute)e;
            Function function = functions.get(fa.functionId());
            if (function == null) {
                return false;
            }
            e = function;
        }
        if (e instanceof ScalarFunction) {
            ScalarFunction sf = (ScalarFunction)e;
            for (Expression arg : sf.arguments()) {
                arg.collectFirstChildren(c -> Verifier.checkGroupByHavingHasOnlyAggs(c, source, missing, functions));
            }
            return true;
        }
        if (e instanceof Score) {
            missing.put(e, source);
            return true;
        }
        if (e.foldable()) {
            return true;
        }
        if (Functions.isAggregate(e)) {
            return true;
        }
        if (e instanceof Attribute) {
            missing.put(e, source);
            return true;
        }
        return false;
    }

    private static boolean checkGroupByAgg(LogicalPlan p, Set<Failure> localFailures, Set<LogicalPlan> groupingFailures, Map<String, Function> functions) {
        if (p instanceof Aggregate) {
            Aggregate a = (Aggregate)p;
            a.groupings().forEach(e -> e.forEachUp(c -> {
                if (Functions.isAggregate(c)) {
                    localFailures.add(Verifier.fail(c, "Cannot use an aggregate [" + c.nodeName().toUpperCase(Locale.ROOT) + "] for grouping", new Object[0]));
                }
                if (c instanceof Score) {
                    localFailures.add(Verifier.fail(c, "Cannot use [SCORE()] for grouping", new Object[0]));
                }
            }));
            if (!localFailures.isEmpty()) {
                return false;
            }
            LinkedHashMap missing = new LinkedHashMap();
            a.aggregates().forEach(ne -> ne.collectFirstChildren(c -> Verifier.checkGroupMatch(c, ne, a.groupings(), missing, functions)));
            if (!missing.isEmpty()) {
                String plural = missing.size() > 1 ? "s" : "";
                localFailures.add(Verifier.fail((Node)missing.values().iterator().next(), "Cannot use non-grouped column" + plural + " %s, expected %s", Expressions.names(missing.keySet()), Expressions.names(a.groupings())));
                return false;
            }
        }
        return true;
    }

    private static boolean checkGroupMatch(Expression e, Node<?> source, List<Expression> groupings, Map<Expression, Node<?>> missing, Map<String, Function> functions) {
        if (e instanceof FunctionAttribute) {
            FunctionAttribute fa = (FunctionAttribute)e;
            Function function = functions.get(fa.functionId());
            if (function == null) {
                return false;
            }
            e = function;
        }
        if (e instanceof ScalarFunction) {
            ScalarFunction sf = (ScalarFunction)e;
            if (Expressions.anyMatch(groupings, e::semanticEquals)) {
                return true;
            }
            for (Expression arg : sf.arguments()) {
                arg.collectFirstChildren(c -> Verifier.checkGroupMatch(c, source, groupings, missing, functions));
            }
            return true;
        }
        if (e instanceof Score) {
            missing.put(e, source);
            return true;
        }
        if (e.foldable()) {
            return true;
        }
        if (Functions.isAggregate(e)) {
            return true;
        }
        Expression exp = e;
        if (e.children().isEmpty()) {
            if (!Expressions.anyMatch(groupings, c -> exp.semanticEquals(exp instanceof Attribute ? Expressions.attribute(c) : c))) {
                missing.put(e, source);
            }
            return true;
        }
        return false;
    }

    private static void checkForScoreInsideFunctions(LogicalPlan p, Set<Failure> localFailures) {
        p.forEachExpressions(e -> e.forEachUp(f -> f.arguments().stream().filter(exp -> exp.anyMatch(Score.class::isInstance)).forEach(exp -> localFailures.add(Verifier.fail(exp, "[SCORE()] cannot be an argument to a function", new Object[0]))), Function.class));
    }

    private static void checkNestedUsedInGroupByOrHaving(LogicalPlan p, Set<Failure> localFailures) {
        ArrayList nested = new ArrayList();
        Consumer<FieldAttribute> match = fa -> {
            if (fa.isNested()) {
                nested.add(fa);
            }
        };
        p.forEachDown(a -> a.groupings().forEach(agg -> agg.forEachUp(match, FieldAttribute.class)), Aggregate.class);
        if (!nested.isEmpty()) {
            localFailures.add(Verifier.fail((Node)nested.get(0), "Grouping isn't (yet) compatible with nested fields " + new AttributeSet(nested).names(), new Object[0]));
            nested.clear();
        }
        p.forEachDown(f -> {
            if (f.child() instanceof Aggregate) {
                f.condition().forEachUp(match, FieldAttribute.class);
            }
        }, Filter.class);
        if (!nested.isEmpty()) {
            localFailures.add(Verifier.fail((Node)nested.get(0), "HAVING isn't (yet) compatible with nested fields " + new AttributeSet(nested).names(), new Object[0]));
        }
    }

    static class Failure {
        private final Node<?> source;
        private final String message;

        Failure(Node<?> source, String message) {
            this.source = source;
            this.message = message;
        }

        Node<?> source() {
            return this.source;
        }

        String message() {
            return this.message;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Failure other = (Failure)obj;
            return Objects.equals(this.source, other.source);
        }

        public String toString() {
            return this.message;
        }
    }
}

