/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.elasticsearch.xpack.core.scheduler.Cron;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public abstract class CronnableSchedule
implements Schedule {
    private static final Comparator<Cron> CRON_COMPARATOR = Comparator.comparing(Cron::expression);
    protected final Cron[] crons;

    CronnableSchedule(String ... expressions) {
        this(CronnableSchedule.crons(expressions));
    }

    private CronnableSchedule(Cron ... crons) {
        assert (crons.length > 0);
        this.crons = crons;
        Arrays.sort(crons, CRON_COMPARATOR);
    }

    public long nextScheduledTimeAfter(long startTime, long time) {
        assert (time >= startTime);
        long nextTime = Long.MAX_VALUE;
        for (Cron cron : this.crons) {
            long nextValidTimeAfter = cron.getNextValidTimeAfter(time);
            boolean previousCronExpired = nextTime == -1L;
            boolean currentCronValid = nextValidTimeAfter > -1L;
            nextTime = previousCronExpired && currentCronValid ? nextValidTimeAfter : Math.min(nextTime, nextValidTimeAfter);
        }
        return nextTime;
    }

    public Cron[] crons() {
        return this.crons;
    }

    public int hashCode() {
        return Objects.hash(this.crons);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CronnableSchedule other = (CronnableSchedule)obj;
        return Objects.deepEquals(this.crons, other.crons);
    }

    static Cron[] crons(String ... expressions) {
        Cron[] crons = new Cron[expressions.length];
        for (int i = 0; i < crons.length; ++i) {
            crons[i] = new Cron(expressions[i]);
        }
        return crons;
    }
}

