/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class WatcherExistsHttpResource
extends PublishableHttpResource {
    private static final Logger logger = Loggers.getLogger(WatcherExistsHttpResource.class);
    public static final Map<String, String> WATCHER_CHECK_PARAMETERS = Collections.singletonMap("filter_path", "features.watcher.available,features.watcher.enabled");
    public static final Set<Integer> XPACK_DOES_NOT_EXIST = Sets.newHashSet((Object[])new Integer[]{RestStatus.NOT_FOUND.getStatus(), RestStatus.BAD_REQUEST.getStatus()});
    private final ClusterService clusterService;
    private final MultiHttpResource watches;

    public WatcherExistsHttpResource(String resourceOwnerName, ClusterService clusterService, MultiHttpResource watches) {
        super(resourceOwnerName, null, WATCHER_CHECK_PARAMETERS);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.watches = Objects.requireNonNull(watches);
    }

    public MultiHttpResource getWatches() {
        return this.watches;
    }

    @Override
    protected PublishableHttpResource.CheckResponse doCheck(RestClient client) {
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return this.checkXPackForWatcher(client);
        }
        return PublishableHttpResource.CheckResponse.EXISTS;
    }

    private PublishableHttpResource.CheckResponse checkXPackForWatcher(RestClient client) {
        block5: {
            Tuple<PublishableHttpResource.CheckResponse, Response> response = this.checkForResource(client, logger, "", "_xpack", "watcher check", this.resourceOwnerName, "monitoring cluster", GET_EXISTS, Sets.newHashSet((Object[])new Integer[]{RestStatus.NOT_FOUND.getStatus(), RestStatus.BAD_REQUEST.getStatus()}));
            PublishableHttpResource.CheckResponse checkResponse = (PublishableHttpResource.CheckResponse)((Object)response.v1());
            if (checkResponse == PublishableHttpResource.CheckResponse.EXISTS) {
                try {
                    if (this.canUseWatcher((Response)response.v2(), XContentType.JSON.xContent())) {
                        return PublishableHttpResource.CheckResponse.DOES_NOT_EXIST;
                    }
                    break block5;
                }
                catch (IOException | RuntimeException e) {
                    logger.error(() -> new ParameterizedMessage("failed to parse [_xpack] on the [{}]", (Object)this.resourceOwnerName), (Throwable)e);
                    return PublishableHttpResource.CheckResponse.ERROR;
                }
            }
            if (checkResponse == PublishableHttpResource.CheckResponse.ERROR) {
                return PublishableHttpResource.CheckResponse.ERROR;
            }
        }
        return PublishableHttpResource.CheckResponse.EXISTS;
    }

    private boolean canUseWatcher(Response response, XContent xContent) throws IOException {
        Map features;
        Map watcher;
        Map xpackInfo = XContentHelper.convertToMap((XContent)xContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        return !xpackInfo.isEmpty() && Boolean.TRUE == (watcher = (Map)(features = (Map)xpackInfo.get("features")).get("watcher")).get("available") && Boolean.TRUE == watcher.get("enabled");
    }

    @Override
    protected boolean doPublish(RestClient client) {
        return this.watches.checkAndPublish(client);
    }
}

