/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public class MultiHttpResource
extends HttpResource {
    private static final Logger logger = Loggers.getLogger(MultiHttpResource.class);
    private final List<HttpResource> resources;

    public MultiHttpResource(String resourceOwnerName, List<? extends HttpResource> resources) {
        super(resourceOwnerName);
        this.resources = Collections.unmodifiableList(resources);
    }

    public List<HttpResource> getResources() {
        return this.resources;
    }

    @Override
    protected boolean doCheckAndPublish(RestClient client) {
        logger.trace("checking sub-resources existence and publishing on the [{}]", (Object)this.resourceOwnerName);
        boolean exists = true;
        for (HttpResource resource : this.resources) {
            if (resource.checkAndPublish(client)) continue;
            exists = false;
            break;
        }
        logger.trace("all sub-resources exist [{}] on the [{}]", (Object)exists, (Object)this.resourceOwnerName);
        return exists;
    }
}

