/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.function.Predicate;
import org.elasticsearch.xpack.core.security.authz.privilege.SystemPrivilege;
import org.elasticsearch.xpack.core.security.user.User;

public class SystemUser
extends User {
    public static final String NAME = "_system";
    public static final String ROLE_NAME = "_system";
    public static final User INSTANCE = new SystemUser();
    private static final Predicate<String> PREDICATE = SystemPrivilege.INSTANCE.predicate();

    private SystemUser() {
        super("_system", "_system");
    }

    @Override
    public boolean equals(Object o) {
        return o == INSTANCE;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static boolean is(User user) {
        return INSTANCE.equals(user);
    }

    public static boolean is(String principal) {
        return "_system".equals(principal);
    }

    public static boolean isAuthorized(String action) {
        return PREDICATE.test(action);
    }
}

