/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;

public class HasPrivilegesRequest
extends ActionRequest
implements UserRequest {
    private String username;
    private String[] clusterPrivileges;
    private RoleDescriptor.IndicesPrivileges[] indexPrivileges;
    private RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges;

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.clusterPrivileges == null) {
            validationException = ValidateActions.addValidationError((String)"clusterPrivileges must not be null", validationException);
        }
        if (this.indexPrivileges == null) {
            validationException = ValidateActions.addValidationError((String)"indexPrivileges must not be null", (ActionRequestValidationException)validationException);
        }
        if (this.applicationPrivileges == null) {
            validationException = ValidateActions.addValidationError((String)"applicationPrivileges must not be null", (ActionRequestValidationException)validationException);
        } else {
            for (RoleDescriptor.ApplicationResourcePrivileges applicationPrivilege : this.applicationPrivileges) {
                try {
                    ApplicationPrivilege.validateApplicationName(applicationPrivilege.getApplication());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (this.clusterPrivileges != null && this.clusterPrivileges.length == 0 && this.indexPrivileges != null && this.indexPrivileges.length == 0 && this.applicationPrivileges != null && this.applicationPrivileges.length == 0) {
            validationException = ValidateActions.addValidationError((String)"must specify at least one privilege", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    public RoleDescriptor.IndicesPrivileges[] indexPrivileges() {
        return this.indexPrivileges;
    }

    public String[] clusterPrivileges() {
        return this.clusterPrivileges;
    }

    public RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges() {
        return this.applicationPrivileges;
    }

    public void indexPrivileges(RoleDescriptor.IndicesPrivileges ... privileges) {
        this.indexPrivileges = privileges;
    }

    public void clusterPrivileges(String ... privileges) {
        this.clusterPrivileges = privileges;
    }

    public void applicationPrivileges(RoleDescriptor.ApplicationResourcePrivileges ... appPrivileges) {
        this.applicationPrivileges = appPrivileges;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.username = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int indexSize = in.readVInt();
        this.indexPrivileges = new RoleDescriptor.IndicesPrivileges[indexSize];
        for (int i = 0; i < indexSize; ++i) {
            this.indexPrivileges[i] = RoleDescriptor.IndicesPrivileges.createFrom(in);
        }
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.applicationPrivileges = (RoleDescriptor.ApplicationResourcePrivileges[])in.readArray(RoleDescriptor.ApplicationResourcePrivileges::createFrom, RoleDescriptor.ApplicationResourcePrivileges[]::new);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indexPrivileges.length);
        for (RoleDescriptor.IndicesPrivileges priv : this.indexPrivileges) {
            priv.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeArray(RoleDescriptor.ApplicationResourcePrivileges::write, (Object[])this.applicationPrivileges);
        }
    }
}

