/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.exporter;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.joda.time.format.DateTimeFormatter;

public final class MonitoringTemplateUtils {
    private static final String TEMPLATE_FILE = "/monitoring-%s.json";
    private static final String TEMPLATE_VERSION_PROPERTY = Pattern.quote("${monitoring.template.version}");
    public static final int LAST_UPDATED_VERSION = Version.V_6_4_0.id;
    public static final String TEMPLATE_VERSION = "6";
    public static final String OLD_TEMPLATE_VERSION = "2";
    public static final String[] TEMPLATE_IDS = new String[]{"alerts", "es", "kibana", "logstash", "beats"};
    public static final String[] OLD_TEMPLATE_IDS = new String[]{"data", "es", "kibana", "logstash", "alerts"};
    public static final String[] PIPELINE_IDS = new String[]{"6", "2"};

    private MonitoringTemplateUtils() {
    }

    public static String templateName(String id) {
        return ".monitoring-" + id;
    }

    public static String oldTemplateName(String id) {
        return ".monitoring-" + id + "-" + OLD_TEMPLATE_VERSION;
    }

    public static String loadTemplate(String id) {
        String resource = String.format(Locale.ROOT, TEMPLATE_FILE, id);
        return TemplateUtils.loadTemplate(resource, TEMPLATE_VERSION, TEMPLATE_VERSION_PROPERTY);
    }

    public static String createEmptyTemplate(String id) {
        return "{\"index_patterns\":[\".monitoring-" + id + "-" + OLD_TEMPLATE_VERSION + "*\"],\"version\":" + LAST_UPDATED_VERSION + "}";
    }

    public static String pipelineName(String id) {
        return "xpack_monitoring_" + id;
    }

    public static XContentBuilder loadPipeline(String id, XContentType type) {
        switch (id) {
            case "6": {
                return MonitoringTemplateUtils.emptyPipeline(type);
            }
            case "2": {
                return MonitoringTemplateUtils.pipelineForApiVersion2(type);
            }
        }
        throw new IllegalArgumentException("unrecognized pipeline API version [" + id + "]");
    }

    static XContentBuilder pipelineForApiVersion2(XContentType type) {
        try {
            return XContentBuilder.builder((XContent)type.xContent()).startObject().field("description", "This pipeline upgrades documents from the older version of the Monitoring API to the newer version (6) by fixing breaking changes in those older documents before they are indexed from the older version (2).").field("version", LAST_UPDATED_VERSION).startArray("processors").startObject().startObject("script").field("source", "boolean legacyIndex = ctx._index == '.monitoring-data-2';if (legacyIndex || ctx._index.startsWith('.monitoring-es-2')) {if (ctx._type == 'cluster_info') {ctx._type = 'cluster_stats';ctx._id = null;} else if (legacyIndex || ctx._type == 'cluster_stats' || ctx._type == 'node') {String index = ctx._index;Object clusterUuid = ctx.cluster_uuid;Object timestamp = ctx.timestamp;ctx.clear();ctx._id = 'xpack_monitoring_2_drop_bucket';ctx._index = index;ctx._type = 'legacy_data';ctx.timestamp = timestamp;ctx.cluster_uuid = clusterUuid;}if (legacyIndex) {ctx._index = '<.monitoring-es-6-{now}>';}}").endObject().endObject().startObject().startObject("rename").field("field", "_type").field("target_field", "type").endObject().endObject().startObject().startObject("set").field("field", "_type").field("value", "doc").endObject().endObject().startObject().startObject("gsub").field("field", "_index").field("pattern", "(.monitoring-\\w+-)2(-.+)").field("replacement", "$16$2").endObject().endObject().endArray().endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create pipeline to upgrade from older version [2] to the newer version [6].", e);
        }
    }

    public static XContentBuilder emptyPipeline(XContentType type) {
        try {
            return XContentBuilder.builder((XContent)type.xContent()).startObject().field("description", "This is a placeholder pipeline for Monitoring API version 6 so that future versions may fix breaking changes.").field("version", LAST_UPDATED_VERSION).startArray("processors").endArray().endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create empty pipeline", e);
        }
    }

    public static String indexName(DateTimeFormatter formatter, MonitoredSystem system, long timestamp) {
        return ".monitoring-" + system.getSystem() + "-" + TEMPLATE_VERSION + "-" + formatter.print(timestamp);
    }
}

