/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.output;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class FlushAcknowledgement
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("flush", new String[0]);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField LAST_FINALIZED_BUCKET_END = new ParseField("last_finalized_bucket_end", new String[0]);
    public static final ConstructingObjectParser<FlushAcknowledgement, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new FlushAcknowledgement((String)a[0], (Date)a[1]));
    private String id;
    private Date lastFinalizedBucketEnd;

    public FlushAcknowledgement(String id, Date lastFinalizedBucketEnd) {
        this.id = id;
        this.lastFinalizedBucketEnd = lastFinalizedBucketEnd;
    }

    public FlushAcknowledgement(StreamInput in) throws IOException {
        this.id = in.readString();
        if (in.getVersion().after(Version.V_5_5_0)) {
            this.lastFinalizedBucketEnd = new Date(in.readVLong());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        if (out.getVersion().after(Version.V_5_5_0)) {
            out.writeVLong(this.lastFinalizedBucketEnd.getTime());
        }
    }

    public String getId() {
        return this.id;
    }

    public Date getLastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (this.lastFinalizedBucketEnd != null) {
            builder.timeField(LAST_FINALIZED_BUCKET_END.getPreferredName(), LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.getTime());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastFinalizedBucketEnd);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlushAcknowledgement other = (FlushAcknowledgement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.lastFinalizedBucketEnd, other.lastFinalizedBucketEnd);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LAST_FINALIZED_BUCKET_END.getPreferredName() + "]");
        }, LAST_FINALIZED_BUCKET_END, ObjectParser.ValueType.VALUE);
    }
}

