/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ChunkingConfig
implements ToXContentObject,
Writeable {
    public static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
    public static final ParseField TIME_SPAN_FIELD = new ParseField("time_span", new String[0]);
    public static final ConstructingObjectParser<ChunkingConfig, Void> METADATA_PARSER = new ConstructingObjectParser("chunking_config", true, a -> new ChunkingConfig((Mode)((Object)((Object)a[0])), (TimeValue)a[1]));
    public static final ConstructingObjectParser<ChunkingConfig, Void> CONFIG_PARSER = new ConstructingObjectParser("chunking_config", false, a -> new ChunkingConfig((Mode)((Object)((Object)a[0])), (TimeValue)a[1]));
    public static final Map<MlParserType, ConstructingObjectParser<ChunkingConfig, Void>> PARSERS = new EnumMap<MlParserType, ConstructingObjectParser<ChunkingConfig, Void>>(MlParserType.class);
    private final Mode mode;
    private final TimeValue timeSpan;

    public ChunkingConfig(StreamInput in) throws IOException {
        this.mode = Mode.readFromStream(in);
        this.timeSpan = in.readOptionalTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.mode.writeTo(out);
        out.writeOptionalTimeValue(this.timeSpan);
    }

    ChunkingConfig(Mode mode, @Nullable TimeValue timeSpan) {
        this.mode = ExceptionsHelper.requireNonNull(mode, MODE_FIELD.getPreferredName());
        this.timeSpan = timeSpan;
        if (mode == Mode.MANUAL) {
            if (timeSpan == null) {
                throw new IllegalArgumentException("when chunk mode is manual time_span is required");
            }
            if (timeSpan.getMillis() <= 0L) {
                throw new IllegalArgumentException("chunk time_span has to be positive");
            }
        } else if (timeSpan != null) {
            throw new IllegalArgumentException("chunk time_span may only be set when mode is manual");
        }
    }

    @Nullable
    public TimeValue getTimeSpan() {
        return this.timeSpan;
    }

    public boolean isEnabled() {
        return this.mode != Mode.OFF;
    }

    Mode getMode() {
        return this.mode;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODE_FIELD.getPreferredName(), (Object)this.mode);
        if (this.timeSpan != null) {
            builder.field(TIME_SPAN_FIELD.getPreferredName(), this.timeSpan.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.timeSpan});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkingConfig other = (ChunkingConfig)obj;
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.timeSpan, other.timeSpan);
    }

    public static ChunkingConfig newAuto() {
        return new ChunkingConfig(Mode.AUTO, null);
    }

    public static ChunkingConfig newOff() {
        return new ChunkingConfig(Mode.OFF, null);
    }

    public static ChunkingConfig newManual(TimeValue timeSpan) {
        return new ChunkingConfig(Mode.MANUAL, timeSpan);
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ConstructingObjectParser<ChunkingConfig, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareField(ConstructingObjectParser.constructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return Mode.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, MODE_FIELD, ObjectParser.ValueType.STRING);
            parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return TimeValue.parseTimeValue((String)p.text(), (String)TIME_SPAN_FIELD.getPreferredName());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, TIME_SPAN_FIELD, ObjectParser.ValueType.STRING);
        }
    }

    public static enum Mode implements Writeable
    {
        AUTO,
        MANUAL,
        OFF;


        public static Mode fromString(String value) {
            return Mode.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Mode readFromStream(StreamInput in) throws IOException {
            return (Mode)in.readEnum(Mode.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

