/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class KeyValueProcessor
extends AbstractProcessor {
    public static final String TYPE = "kv";
    private static final Pattern STRIP_BRACKETS = Pattern.compile("(^[\\(\\[<\"'])|([\\]\\)>\"']$)");
    private final String field;
    private final String fieldSplit;
    private final String valueSplit;
    private final Set<String> includeKeys;
    private final Set<String> excludeKeys;
    private final String targetField;
    private final boolean ignoreMissing;
    private final Consumer<IngestDocument> execution;

    KeyValueProcessor(String tag, String field, String fieldSplit, String valueSplit, Set<String> includeKeys, Set<String> excludeKeys, String targetField, boolean ignoreMissing, String trimKey, String trimValue, boolean stripBrackets, String prefix) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.fieldSplit = fieldSplit;
        this.valueSplit = valueSplit;
        this.includeKeys = includeKeys;
        this.excludeKeys = excludeKeys;
        this.ignoreMissing = ignoreMissing;
        this.execution = KeyValueProcessor.buildExecution(fieldSplit, valueSplit, field, includeKeys, excludeKeys, targetField, ignoreMissing, trimKey, trimValue, stripBrackets, prefix);
    }

    private static Consumer<IngestDocument> buildExecution(String fieldSplit, String valueSplit, String field, Set<String> includeKeys, Set<String> excludeKeys, String targetField, boolean ignoreMissing, String trimKey, String trimValue, boolean stripBrackets, String prefix) {
        Predicate<String> keyFilter = includeKeys == null ? (excludeKeys == null ? key -> true : key -> !excludeKeys.contains(key)) : (excludeKeys == null ? includeKeys::contains : key -> includeKeys.contains(key) && !excludeKeys.contains(key));
        String keyPrefix = prefix == null ? "" : prefix;
        String fieldPathPrefix = targetField == null ? keyPrefix : targetField + "." + keyPrefix;
        Function<String, String> keyPrefixer = fieldPathPrefix.isEmpty() ? val -> val : val -> fieldPathPrefix + val;
        Function<String, String[]> fieldSplitter = KeyValueProcessor.buildSplitter(fieldSplit, true);
        Function<String, String[]> valueSplitter = KeyValueProcessor.buildSplitter(valueSplit, false);
        Function<String, String> keyTrimmer = KeyValueProcessor.buildTrimmer(trimKey);
        Function<String, String> bracketStrip = stripBrackets ? val -> STRIP_BRACKETS.matcher((CharSequence)val).replaceAll("") : val -> val;
        Function<String, String> valueTrimmer = KeyValueProcessor.buildTrimmer(trimValue);
        return document -> {
            String value = (String)document.getFieldValue(field, String.class, ignoreMissing);
            if (value == null) {
                if (ignoreMissing) {
                    return;
                }
                throw new IllegalArgumentException("field [" + field + "] is null, cannot extract key-value pairs.");
            }
            for (String part : (String[])fieldSplitter.apply(value)) {
                String[] kv = (String[])valueSplitter.apply(part);
                if (kv.length != 2) {
                    throw new IllegalArgumentException("field [" + field + "] does not contain value_split [" + valueSplit + "]");
                }
                String key = (String)keyTrimmer.apply(kv[0]);
                if (!keyFilter.test(key)) continue;
                KeyValueProcessor.append(document, (String)keyPrefixer.apply(key), (String)valueTrimmer.apply((String)bracketStrip.apply(kv[1])));
            }
        };
    }

    private static Function<String, String> buildTrimmer(String trim) {
        if (trim == null) {
            return val -> val;
        }
        Pattern pattern = Pattern.compile("(^([" + trim + "]+))|([" + trim + "]+$)");
        return val -> pattern.matcher((CharSequence)val).replaceAll("");
    }

    private static Function<String, String[]> buildSplitter(String split, boolean fields) {
        int limit;
        int n = limit = fields ? 0 : 2;
        if (split.length() > 2 || split.length() == 2 && split.charAt(0) != '\\') {
            Pattern splitPattern = Pattern.compile(split);
            return val -> splitPattern.split((CharSequence)val, limit);
        }
        return val -> val.split(split, limit);
    }

    String getField() {
        return this.field;
    }

    String getFieldSplit() {
        return this.fieldSplit;
    }

    String getValueSplit() {
        return this.valueSplit;
    }

    Set<String> getIncludeKeys() {
        return this.includeKeys;
    }

    Set<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    String getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    private static void append(IngestDocument document, String targetField, String value) {
        if (document.hasField(targetField)) {
            document.appendFieldValue(targetField, (Object)value);
        } else {
            document.setFieldValue(targetField, (Object)value);
        }
    }

    public void execute(IngestDocument document) {
        this.execution.accept(document);
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory {
        public KeyValueProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            List excludeKeysList;
            String field = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            String fieldSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field_split");
            String valueSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"value_split");
            String trimKey = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"trim_key");
            String trimValue = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"trim_value");
            String prefix = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"prefix");
            boolean stripBrackets = ConfigurationUtils.readBooleanProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"strip_brackets", (boolean)false);
            Set<String> includeKeys = null;
            Set<String> excludeKeys = null;
            List includeKeysList = ConfigurationUtils.readOptionalList((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"include_keys");
            if (includeKeysList != null) {
                includeKeys = Collections.unmodifiableSet(Sets.newHashSet((Iterable)includeKeysList));
            }
            if ((excludeKeysList = ConfigurationUtils.readOptionalList((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"exclude_keys")) != null) {
                excludeKeys = Collections.unmodifiableSet(Sets.newHashSet((Iterable)excludeKeysList));
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new KeyValueProcessor(processorTag, field, fieldSplit, valueSplit, includeKeys, excludeKeys, targetField, ignoreMissing, trimKey, trimValue, stripBrackets, prefix);
        }
    }
}

