/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.client.RestClient;

public abstract class HttpResource {
    protected final String resourceOwnerName;
    protected final AtomicReference<State> state;

    protected HttpResource(String resourceOwnerName) {
        this(resourceOwnerName, true);
    }

    protected HttpResource(String resourceOwnerName, boolean dirty) {
        this.resourceOwnerName = Objects.requireNonNull(resourceOwnerName);
        this.state = new AtomicReference<State>(dirty ? State.DIRTY : State.CLEAN);
    }

    public String getResourceOwnerName() {
        return this.resourceOwnerName;
    }

    public boolean isDirty() {
        return this.state.get() != State.CLEAN;
    }

    public final void markDirty() {
        this.state.set(State.DIRTY);
    }

    public final boolean checkAndPublishIfDirty(RestClient client) {
        State state = this.state.get();
        return state == State.CLEAN || this.blockUntilCheckAndPublish(client);
    }

    private synchronized boolean blockUntilCheckAndPublish(RestClient client) {
        State state = this.state.get();
        return state == State.CLEAN || state == State.DIRTY && this.checkAndPublish(client);
    }

    public final synchronized boolean checkAndPublish(RestClient client) {
        this.state.set(State.CHECKING);
        boolean success = false;
        try {
            success = this.doCheckAndPublish(client);
            this.state.compareAndSet(State.CHECKING, success ? State.CLEAN : State.DIRTY);
        }
        catch (Throwable throwable) {
            this.state.compareAndSet(State.CHECKING, success ? State.CLEAN : State.DIRTY);
            throw throwable;
        }
        return success;
    }

    protected abstract boolean doCheckAndPublish(RestClient var1);

    static enum State {
        CLEAN,
        CHECKING,
        DIRTY;

    }
}

