/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.CompoundDateTimeFormatter;

public class DateFormatters {
    private static final DateTimeFormatter TIME_ZONE_FORMATTER_NO_COLON = new DateTimeFormatterBuilder().appendOffset("+HHmm", "Z").toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_YEAR_MONTH_DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_1 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_DATE_OPTIONAL_TIME_FORMATTER_2 = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).optionalStart().appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_DATE_OPTIONAL_TIME = new CompoundDateTimeFormatter(STRICT_DATE_OPTIONAL_TIME_FORMATTER_1, STRICT_DATE_OPTIONAL_TIME_FORMATTER_2);
    private static final DateTimeFormatter BASIC_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter BASIC_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_TIME_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter BASIC_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(BASIC_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_T_TIME_PRINTER = new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_PRINTER).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_T_TIME_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_FORMATTER).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter BASIC_T_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(BASIC_T_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_T_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter BASIC_T_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_YEAR_MONTH_DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).append(BASIC_T_TIME_FORMATTER).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_DATE_TIME_PRINTER = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).append(BASIC_T_TIME_PRINTER).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter BASIC_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_DATE_T = new DateTimeFormatterBuilder().append(BASIC_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter BASIC_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(BASIC_DATE_T).append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_DATE_T).append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter BASIC_ORDINAL_DATE = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("yyyyDDD", Locale.ROOT));
    private static final CompoundDateTimeFormatter BASIC_ORDINAL_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendPattern("yyyyDDD").append(BASIC_T_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendPattern("yyyyDDD").append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter BASIC_ORDINAL_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendPattern("yyyyDDD").appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendPattern("yyyyDDD").appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter BASIC_WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(IsoFields.WEEK_BASED_YEAR).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_BASIC_WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().parseStrict().appendValue(IsoFields.WEEK_BASED_YEAR, 4).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_BASIC_WEEK_DATE_PRINTER = new DateTimeFormatterBuilder().parseStrict().appendValue(IsoFields.WEEK_BASED_YEAR, 4).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2, 2, SignStyle.NEVER).appendValue(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_BASIC_WEEK_DATE = new CompoundDateTimeFormatter(STRICT_BASIC_WEEK_DATE_PRINTER, STRICT_BASIC_WEEK_DATE_FORMATTER);
    private static final CompoundDateTimeFormatter STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmssX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_FORMATTER).append(DateTimeFormatter.ofPattern("'T'HHmmssX", Locale.ROOT)).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_BASIC_WEEK_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_PRINTER).append(DateTimeFormatter.ofPattern("'T'HHmmss.SSSX", Locale.ROOT)).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_BASIC_WEEK_DATE_FORMATTER).append(DateTimeFormatter.ofPattern("'T'HHmmss.SSSX", Locale.ROOT)).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_DATE = new CompoundDateTimeFormatter(DateTimeFormatter.ISO_LOCAL_DATE.withResolverStyle(ResolverStyle.LENIENT));
    private static final CompoundDateTimeFormatter STRICT_DATE_HOUR = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH", Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_DATE_HOUR_MINUTE = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm", Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_YEAR_MONTH_DAY = new CompoundDateTimeFormatter(STRICT_YEAR_MONTH_DAY_FORMATTER);
    private static final CompoundDateTimeFormatter STRICT_YEAR_MONTH = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_YEAR = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter(Locale.ROOT));
    private static final CompoundDateTimeFormatter STRICT_HOUR_MINUTE_SECOND = new CompoundDateTimeFormatter(STRICT_HOUR_MINUTE_SECOND_FORMATTER);
    private static final DateTimeFormatter STRICT_DATE_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_DATE_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_ORDINAL_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_DATE_TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral('T').append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_DATE_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_DATE_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS_FORMATTER = new DateTimeFormatterBuilder().append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER = new DateTimeFormatterBuilder().append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private static final CompoundDateTimeFormatter STRICT_HOUR_MINUTE_SECOND_MILLIS;
    private static final CompoundDateTimeFormatter STRICT_HOUR_MINUTE_SECOND_FRACTION;
    private static final CompoundDateTimeFormatter STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION;
    private static final CompoundDateTimeFormatter STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS;
    private static final CompoundDateTimeFormatter STRICT_HOUR;
    private static final CompoundDateTimeFormatter STRICT_HOUR_MINUTE;
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE;
    private static final CompoundDateTimeFormatter STRICT_ORDINAL_DATE_TIME;
    private static final DateTimeFormatter STRICT_TIME_FORMATTER_BASE;
    private static final DateTimeFormatter STRICT_TIME_PRINTER;
    private static final CompoundDateTimeFormatter STRICT_TIME;
    private static final CompoundDateTimeFormatter STRICT_T_TIME;
    private static final DateTimeFormatter STRICT_TIME_NO_MILLIS_BASE;
    private static final CompoundDateTimeFormatter STRICT_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter STRICT_T_TIME_NO_MILLIS;
    private static final DateTimeFormatter ISO_WEEK_DATE;
    private static final DateTimeFormatter ISO_WEEK_DATE_T;
    private static final CompoundDateTimeFormatter STRICT_WEEK_DATE;
    private static final CompoundDateTimeFormatter STRICT_WEEK_DATE_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter STRICT_WEEK_DATE_TIME;
    private static final CompoundDateTimeFormatter STRICT_WEEKYEAR;
    private static final DateTimeFormatter STRICT_WEEKYEAR_WEEK_FORMATTER;
    private static final CompoundDateTimeFormatter STRICT_WEEKYEAR_WEEK;
    private static final CompoundDateTimeFormatter STRICT_WEEKYEAR_WEEK_DAY;
    private static final CompoundDateTimeFormatter STRICT_DATE_HOUR_MINUTE_SECOND;
    private static final CompoundDateTimeFormatter BASIC_DATE;
    private static final DateTimeFormatter STRICT_ORDINAL_DATE_FORMATTER;
    private static final CompoundDateTimeFormatter STRICT_ORDINAL_DATE;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter HOUR_MINUTE_FORMATTER;
    private static final CompoundDateTimeFormatter DATE_OPTIONAL_TIME;
    private static final DateTimeFormatter HOUR_MINUTE_SECOND_FORMATTER;
    private static final DateTimeFormatter HOUR_MINUTE_SECOND_MILLIS_FORMATTER;
    private static final DateTimeFormatter ORDINAL_DATE_FORMATTER;
    private static final DateTimeFormatter ORDINAL_DATE_PRINTER;
    private static final CompoundDateTimeFormatter ORDINAL_DATE;
    private static final DateTimeFormatter TIME_NO_MILLIS_FORMATTER;
    private static final DateTimeFormatter T_TIME_NO_MILLIS_FORMATTER;
    private static final DateTimeFormatter TIME_PREFIX;
    private static final DateTimeFormatter WEEK_DATE_FORMATTER;
    private static final CompoundDateTimeFormatter WEEK_YEAR;
    private static final CompoundDateTimeFormatter YEAR;
    private static final CompoundDateTimeFormatter EPOCH_SECOND;
    private static final CompoundDateTimeFormatter EPOCH_MILLIS;
    private static final CompoundDateTimeFormatter DATE_HOUR;
    private static final CompoundDateTimeFormatter DATE_HOUR_MINUTE_SECOND_MILLIS;
    private static final CompoundDateTimeFormatter DATE_HOUR_MINUTE_SECOND_FRACTION;
    private static final CompoundDateTimeFormatter DATE_HOUR_MINUTE;
    private static final CompoundDateTimeFormatter DATE_HOUR_MINUTE_SECOND;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final CompoundDateTimeFormatter DATE_TIME;
    private static final CompoundDateTimeFormatter BASIC_WEEK_DATE;
    private static final CompoundDateTimeFormatter DATE;
    private static final DateTimeFormatter DATE_TIME_NO_MILLIS_PRINTER;
    private static final DateTimeFormatter DATE_TIME_PREFIX;
    private static final CompoundDateTimeFormatter DATE_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter HOUR_MINUTE_SECOND_MILLIS;
    private static final CompoundDateTimeFormatter HOUR_MINUTE;
    private static final CompoundDateTimeFormatter HOUR_MINUTE_SECOND;
    private static final CompoundDateTimeFormatter HOUR;
    private static final DateTimeFormatter ORDINAL_DATE_TIME_FORMATTER_BASE;
    private static final CompoundDateTimeFormatter ORDINAL_DATE_TIME;
    private static final DateTimeFormatter ORDINAL_DATE_TIME_NO_MILLIS_BASE;
    private static final CompoundDateTimeFormatter ORDINAL_DATE_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter WEEK_DATE_TIME;
    private static final CompoundDateTimeFormatter WEEK_DATE_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter BASIC_WEEK_DATE_TIME;
    private static final CompoundDateTimeFormatter BASIC_WEEK_DATE_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter TIME;
    private static final CompoundDateTimeFormatter TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter T_TIME;
    private static final CompoundDateTimeFormatter T_TIME_NO_MILLIS;
    private static final CompoundDateTimeFormatter YEAR_MONTH;
    private static final CompoundDateTimeFormatter YEAR_MONTH_DAY;
    private static final CompoundDateTimeFormatter WEEK_DATE;
    private static final CompoundDateTimeFormatter WEEKYEAR_WEEK;
    private static final CompoundDateTimeFormatter WEEKYEAR_WEEK_DAY;
    private static final ZonedDateTime EPOCH_ZONED_DATE_TIME;

    public static CompoundDateTimeFormatter forPattern(String input) {
        return DateFormatters.forPattern(input, Locale.ROOT);
    }

    public static CompoundDateTimeFormatter forPattern(String input, Locale locale) {
        if (Strings.hasLength(input)) {
            input = input.trim();
        }
        if (input == null || input.length() == 0) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if ("basicDate".equals(input) || "basic_date".equals(input)) {
            return BASIC_DATE;
        }
        if ("basicDateTime".equals(input) || "basic_date_time".equals(input)) {
            return BASIC_DATE_TIME;
        }
        if ("basicDateTimeNoMillis".equals(input) || "basic_date_time_no_millis".equals(input)) {
            return BASIC_DATE_TIME_NO_MILLIS;
        }
        if ("basicOrdinalDate".equals(input) || "basic_ordinal_date".equals(input)) {
            return BASIC_ORDINAL_DATE;
        }
        if ("basicOrdinalDateTime".equals(input) || "basic_ordinal_date_time".equals(input)) {
            return BASIC_ORDINAL_DATE_TIME;
        }
        if ("basicOrdinalDateTimeNoMillis".equals(input) || "basic_ordinal_date_time_no_millis".equals(input)) {
            return BASIC_ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("basicTime".equals(input) || "basic_time".equals(input)) {
            return BASIC_TIME;
        }
        if ("basicTimeNoMillis".equals(input) || "basic_time_no_millis".equals(input)) {
            return BASIC_TIME_NO_MILLIS;
        }
        if ("basicTTime".equals(input) || "basic_t_time".equals(input)) {
            return BASIC_T_TIME;
        }
        if ("basicTTimeNoMillis".equals(input) || "basic_t_time_no_millis".equals(input)) {
            return BASIC_T_TIME_NO_MILLIS;
        }
        if ("basicWeekDate".equals(input) || "basic_week_date".equals(input)) {
            return BASIC_WEEK_DATE;
        }
        if ("basicWeekDateTime".equals(input) || "basic_week_date_time".equals(input)) {
            return BASIC_WEEK_DATE_TIME;
        }
        if ("basicWeekDateTimeNoMillis".equals(input) || "basic_week_date_time_no_millis".equals(input)) {
            return BASIC_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("date".equals(input)) {
            return DATE;
        }
        if ("dateHour".equals(input) || "date_hour".equals(input)) {
            return DATE_HOUR;
        }
        if ("dateHourMinute".equals(input) || "date_hour_minute".equals(input)) {
            return DATE_HOUR_MINUTE;
        }
        if ("dateHourMinuteSecond".equals(input) || "date_hour_minute_second".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND;
        }
        if ("dateHourMinuteSecondFraction".equals(input) || "date_hour_minute_second_fraction".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("dateHourMinuteSecondMillis".equals(input) || "date_hour_minute_second_millis".equals(input)) {
            return DATE_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("dateOptionalTime".equals(input) || "date_optional_time".equals(input)) {
            return DATE_OPTIONAL_TIME;
        }
        if ("dateTime".equals(input) || "date_time".equals(input)) {
            return DATE_TIME;
        }
        if ("dateTimeNoMillis".equals(input) || "date_time_no_millis".equals(input)) {
            return DATE_TIME_NO_MILLIS;
        }
        if ("hour".equals(input)) {
            return HOUR;
        }
        if ("hourMinute".equals(input) || "hour_minute".equals(input)) {
            return HOUR_MINUTE;
        }
        if ("hourMinuteSecond".equals(input) || "hour_minute_second".equals(input)) {
            return HOUR_MINUTE_SECOND;
        }
        if ("hourMinuteSecondFraction".equals(input) || "hour_minute_second_fraction".equals(input)) {
            return HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("hourMinuteSecondMillis".equals(input) || "hour_minute_second_millis".equals(input)) {
            return HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("ordinalDate".equals(input) || "ordinal_date".equals(input)) {
            return ORDINAL_DATE;
        }
        if ("ordinalDateTime".equals(input) || "ordinal_date_time".equals(input)) {
            return ORDINAL_DATE_TIME;
        }
        if ("ordinalDateTimeNoMillis".equals(input) || "ordinal_date_time_no_millis".equals(input)) {
            return ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("time".equals(input)) {
            return TIME;
        }
        if ("timeNoMillis".equals(input) || "time_no_millis".equals(input)) {
            return TIME_NO_MILLIS;
        }
        if ("tTime".equals(input) || "t_time".equals(input)) {
            return T_TIME;
        }
        if ("tTimeNoMillis".equals(input) || "t_time_no_millis".equals(input)) {
            return T_TIME_NO_MILLIS;
        }
        if ("weekDate".equals(input) || "week_date".equals(input)) {
            return WEEK_DATE;
        }
        if ("weekDateTime".equals(input) || "week_date_time".equals(input)) {
            return WEEK_DATE_TIME;
        }
        if ("weekDateTimeNoMillis".equals(input) || "week_date_time_no_millis".equals(input)) {
            return WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("weekyear".equals(input) || "week_year".equals(input)) {
            return WEEK_YEAR;
        }
        if ("weekyearWeek".equals(input) || "weekyear_week".equals(input)) {
            return WEEKYEAR_WEEK;
        }
        if ("weekyearWeekDay".equals(input) || "weekyear_week_day".equals(input)) {
            return WEEKYEAR_WEEK_DAY;
        }
        if ("year".equals(input)) {
            return YEAR;
        }
        if ("yearMonth".equals(input) || "year_month".equals(input)) {
            return YEAR_MONTH;
        }
        if ("yearMonthDay".equals(input) || "year_month_day".equals(input)) {
            return YEAR_MONTH_DAY;
        }
        if ("epoch_second".equals(input)) {
            return EPOCH_SECOND;
        }
        if ("epoch_millis".equals(input)) {
            return EPOCH_MILLIS;
        }
        if ("strictBasicWeekDate".equals(input) || "strict_basic_week_date".equals(input)) {
            return STRICT_BASIC_WEEK_DATE;
        }
        if ("strictBasicWeekDateTime".equals(input) || "strict_basic_week_date_time".equals(input)) {
            return STRICT_BASIC_WEEK_DATE_TIME;
        }
        if ("strictBasicWeekDateTimeNoMillis".equals(input) || "strict_basic_week_date_time_no_millis".equals(input)) {
            return STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("strictDate".equals(input) || "strict_date".equals(input)) {
            return STRICT_DATE;
        }
        if ("strictDateHour".equals(input) || "strict_date_hour".equals(input)) {
            return STRICT_DATE_HOUR;
        }
        if ("strictDateHourMinute".equals(input) || "strict_date_hour_minute".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE;
        }
        if ("strictDateHourMinuteSecond".equals(input) || "strict_date_hour_minute_second".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND;
        }
        if ("strictDateHourMinuteSecondFraction".equals(input) || "strict_date_hour_minute_second_fraction".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("strictDateHourMinuteSecondMillis".equals(input) || "strict_date_hour_minute_second_millis".equals(input)) {
            return STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("strictDateOptionalTime".equals(input) || "strict_date_optional_time".equals(input)) {
            return STRICT_DATE_OPTIONAL_TIME;
        }
        if ("strictDateTime".equals(input) || "strict_date_time".equals(input)) {
            return STRICT_DATE_TIME;
        }
        if ("strictDateTimeNoMillis".equals(input) || "strict_date_time_no_millis".equals(input)) {
            return STRICT_DATE_TIME_NO_MILLIS;
        }
        if ("strictHour".equals(input) || "strict_hour".equals(input)) {
            return STRICT_HOUR;
        }
        if ("strictHourMinute".equals(input) || "strict_hour_minute".equals(input)) {
            return STRICT_HOUR_MINUTE;
        }
        if ("strictHourMinuteSecond".equals(input) || "strict_hour_minute_second".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND;
        }
        if ("strictHourMinuteSecondFraction".equals(input) || "strict_hour_minute_second_fraction".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND_FRACTION;
        }
        if ("strictHourMinuteSecondMillis".equals(input) || "strict_hour_minute_second_millis".equals(input)) {
            return STRICT_HOUR_MINUTE_SECOND_MILLIS;
        }
        if ("strictOrdinalDate".equals(input) || "strict_ordinal_date".equals(input)) {
            return STRICT_ORDINAL_DATE;
        }
        if ("strictOrdinalDateTime".equals(input) || "strict_ordinal_date_time".equals(input)) {
            return STRICT_ORDINAL_DATE_TIME;
        }
        if ("strictOrdinalDateTimeNoMillis".equals(input) || "strict_ordinal_date_time_no_millis".equals(input)) {
            return STRICT_ORDINAL_DATE_TIME_NO_MILLIS;
        }
        if ("strictTime".equals(input) || "strict_time".equals(input)) {
            return STRICT_TIME;
        }
        if ("strictTimeNoMillis".equals(input) || "strict_time_no_millis".equals(input)) {
            return STRICT_TIME_NO_MILLIS;
        }
        if ("strictTTime".equals(input) || "strict_t_time".equals(input)) {
            return STRICT_T_TIME;
        }
        if ("strictTTimeNoMillis".equals(input) || "strict_t_time_no_millis".equals(input)) {
            return STRICT_T_TIME_NO_MILLIS;
        }
        if ("strictWeekDate".equals(input) || "strict_week_date".equals(input)) {
            return STRICT_WEEK_DATE;
        }
        if ("strictWeekDateTime".equals(input) || "strict_week_date_time".equals(input)) {
            return STRICT_WEEK_DATE_TIME;
        }
        if ("strictWeekDateTimeNoMillis".equals(input) || "strict_week_date_time_no_millis".equals(input)) {
            return STRICT_WEEK_DATE_TIME_NO_MILLIS;
        }
        if ("strictWeekyear".equals(input) || "strict_weekyear".equals(input)) {
            return STRICT_WEEKYEAR;
        }
        if ("strictWeekyearWeek".equals(input) || "strict_weekyear_week".equals(input)) {
            return STRICT_WEEKYEAR_WEEK;
        }
        if ("strictWeekyearWeekDay".equals(input) || "strict_weekyear_week_day".equals(input)) {
            return STRICT_WEEKYEAR_WEEK_DAY;
        }
        if ("strictYear".equals(input) || "strict_year".equals(input)) {
            return STRICT_YEAR;
        }
        if ("strictYearMonth".equals(input) || "strict_year_month".equals(input)) {
            return STRICT_YEAR_MONTH;
        }
        if ("strictYearMonthDay".equals(input) || "strict_year_month_day".equals(input)) {
            return STRICT_YEAR_MONTH_DAY;
        }
        if (Strings.hasLength(input) && input.contains("||")) {
            String[] formats = Strings.delimitedListToStringArray(input, "||");
            if (formats.length == 1) {
                return DateFormatters.forPattern(formats[0], locale);
            }
            LinkedHashSet<DateTimeFormatter> parsers = new LinkedHashSet<DateTimeFormatter>(formats.length);
            for (String format : formats) {
                CompoundDateTimeFormatter dateTimeFormatter = DateFormatters.forPattern(format, locale);
                try {
                    parsers.addAll(Arrays.asList(dateTimeFormatter.parsers));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid format: [" + input + "]: " + e.getMessage(), e);
                }
            }
            return new CompoundDateTimeFormatter(parsers.toArray(new DateTimeFormatter[0]));
        }
        try {
            return new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendPattern(input).toFormatter(locale));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid format: [" + input + "]: " + e.getMessage(), e);
        }
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor accessor) {
        return DateFormatters.toZonedDateTime(accessor, EPOCH_ZONED_DATE_TIME);
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZonedDateTime defaults) {
        try {
            return ZonedDateTime.from(accessor);
        }
        catch (DateTimeException dateTimeException) {
            ZonedDateTime result = defaults;
            if (accessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                result = result.with(ChronoField.INSTANT_SECONDS, accessor.getLong(ChronoField.INSTANT_SECONDS));
                if (accessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                    result = result.with(ChronoField.NANO_OF_SECOND, accessor.getLong(ChronoField.NANO_OF_SECOND));
                }
                return result;
            }
            if (accessor.isSupported(ChronoField.YEAR)) {
                result = result.with(ChronoField.YEAR, accessor.getLong(ChronoField.YEAR));
            } else if (accessor.isSupported(ChronoField.YEAR_OF_ERA)) {
                result = result.with(ChronoField.YEAR_OF_ERA, accessor.getLong(ChronoField.YEAR_OF_ERA));
            } else {
                if (accessor.isSupported(WeekFields.ISO.weekBasedYear())) {
                    if (accessor.isSupported(WeekFields.ISO.weekOfWeekBasedYear())) {
                        return LocalDate.from(result).with(WeekFields.ISO.weekBasedYear(), accessor.getLong(WeekFields.ISO.weekBasedYear())).withDayOfMonth(1).with(WeekFields.ISO.weekOfWeekBasedYear(), accessor.getLong(WeekFields.ISO.weekOfWeekBasedYear())).atStartOfDay(ZoneOffset.UTC);
                    }
                    return LocalDate.from(result).with(WeekFields.ISO.weekBasedYear(), accessor.getLong(WeekFields.ISO.weekBasedYear())).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)).atStartOfDay(defaults.getZone());
                }
                if (accessor.isSupported(IsoFields.WEEK_BASED_YEAR)) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, accessor.getLong(IsoFields.WEEK_BASED_YEAR));
                    if (accessor.isSupported(IsoFields.WEEK_OF_WEEK_BASED_YEAR)) {
                        result = result.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, accessor.getLong(IsoFields.WEEK_OF_WEEK_BASED_YEAR));
                    }
                    return result;
                }
            }
            if (accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                result = result.with(ChronoField.MONTH_OF_YEAR, accessor.getLong(ChronoField.MONTH_OF_YEAR));
            }
            if (accessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                result = result.with(ChronoField.DAY_OF_MONTH, accessor.getLong(ChronoField.DAY_OF_MONTH));
            }
            if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                result = result.with(ChronoField.HOUR_OF_DAY, accessor.getLong(ChronoField.HOUR_OF_DAY));
            }
            if (accessor.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                result = result.with(ChronoField.MINUTE_OF_HOUR, accessor.getLong(ChronoField.MINUTE_OF_HOUR));
            }
            if (accessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                result = result.with(ChronoField.SECOND_OF_MINUTE, accessor.getLong(ChronoField.SECOND_OF_MINUTE));
            }
            if (accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                result = result.withZoneSameLocal(ZoneOffset.ofTotalSeconds(accessor.get(ChronoField.OFFSET_SECONDS)));
            }
            if (accessor.isSupported(ChronoField.MILLI_OF_SECOND)) {
                result = result.with(ChronoField.MILLI_OF_SECOND, accessor.getLong(ChronoField.MILLI_OF_SECOND));
            }
            if (accessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                result = result.with(ChronoField.NANO_OF_SECOND, accessor.getLong(ChronoField.NANO_OF_SECOND));
            }
            return result;
        }
    }

    static {
        STRICT_HOUR_MINUTE_SECOND_FRACTION = STRICT_HOUR_MINUTE_SECOND_MILLIS = new CompoundDateTimeFormatter(STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER, STRICT_HOUR_MINUTE_SECOND_MILLIS_FORMATTER);
        STRICT_DATE_HOUR_MINUTE_SECOND_MILLIS = STRICT_DATE_HOUR_MINUTE_SECOND_FRACTION = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT));
        STRICT_HOUR = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("HH", Locale.ROOT));
        STRICT_HOUR_MINUTE = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("HH:mm", Locale.ROOT));
        STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).appendLiteral('T').appendPattern("HH:mm").optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        STRICT_ORDINAL_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_ORDINAL_DATE_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        STRICT_TIME_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
        STRICT_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_T_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral('T').append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        STRICT_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_T_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        ISO_WEEK_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).toFormatter(Locale.ROOT);
        ISO_WEEK_DATE_T = new DateTimeFormatterBuilder().append(ISO_WEEK_DATE).appendLiteral('T').toFormatter(Locale.ROOT);
        STRICT_WEEK_DATE = new CompoundDateTimeFormatter(ISO_WEEK_DATE);
        STRICT_WEEK_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_WEEK_DATE_TIME = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_PRINTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ISO_WEEK_DATE_T).append(STRICT_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        STRICT_WEEKYEAR = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear(), 4, 10, SignStyle.EXCEEDS_PAD).toFormatter(Locale.ROOT));
        STRICT_WEEKYEAR_WEEK_FORMATTER = new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear(), 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear(), 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        STRICT_WEEKYEAR_WEEK = new CompoundDateTimeFormatter(STRICT_WEEKYEAR_WEEK_FORMATTER);
        STRICT_WEEKYEAR_WEEK_DAY = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_WEEKYEAR_WEEK_FORMATTER).appendLiteral("-").appendValue(WeekFields.ISO.dayOfWeek()).toFormatter(Locale.ROOT));
        STRICT_DATE_HOUR_MINUTE_SECOND = new CompoundDateTimeFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT));
        BASIC_DATE = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC), new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 4, SignStyle.NORMAL).appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC));
        STRICT_ORDINAL_DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3).optionalStart().toFormatter(Locale.ROOT);
        STRICT_ORDINAL_DATE = new CompoundDateTimeFormatter(STRICT_ORDINAL_DATE_FORMATTER);
        DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 4, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        HOUR_MINUTE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        DATE_OPTIONAL_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE_OPTIONAL_TIME.printer, new DateTimeFormatterBuilder().append(DATE_FORMATTER).optionalStart().appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).optionalStart().appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().optionalEnd().toFormatter(Locale.ROOT));
        HOUR_MINUTE_SECOND_FORMATTER = new DateTimeFormatterBuilder().append(HOUR_MINUTE_FORMATTER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        HOUR_MINUTE_SECOND_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        ORDINAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 1, 3, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        ORDINAL_DATE_PRINTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        ORDINAL_DATE = new CompoundDateTimeFormatter(ORDINAL_DATE_PRINTER, ORDINAL_DATE_FORMATTER);
        TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT);
        T_TIME_NO_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_NO_MILLIS_FORMATTER).toFormatter(Locale.ROOT);
        TIME_PREFIX = new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).toFormatter(Locale.ROOT);
        WEEK_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).toFormatter(Locale.ROOT);
        WEEK_YEAR = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).toFormatter(Locale.ROOT));
        YEAR = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).toFormatter(Locale.ROOT));
        EPOCH_SECOND = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS).toFormatter(Locale.ROOT));
        EPOCH_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS, 1, 19, SignStyle.NEVER).appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter(Locale.ROOT));
        DATE_HOUR = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE_HOUR.printer, new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE_SECOND_FRACTION = DATE_HOUR_MINUTE_SECOND_MILLIS = new CompoundDateTimeFormatter(new DateTimeFormatterBuilder().append(STRICT_YEAR_MONTH_DAY_FORMATTER).appendLiteral("T").append(STRICT_HOUR_MINUTE_SECOND_MILLIS_PRINTER).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_SECOND_MILLIS_FORMATTER).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE_HOUR_MINUTE.printer, new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_FORMATTER).toFormatter(Locale.ROOT));
        DATE_HOUR_MINUTE_SECOND = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE_HOUR_MINUTE_SECOND.printer, new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral("T").append(HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT));
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        DATE_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE_TIME.printer, new DateTimeFormatterBuilder().append(DATE_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE = new CompoundDateTimeFormatter(DateFormatters.STRICT_BASIC_WEEK_DATE.printer, BASIC_WEEK_DATE_FORMATTER);
        DATE = new CompoundDateTimeFormatter(DateFormatters.STRICT_DATE.printer, DATE_FORMATTER);
        DATE_TIME_NO_MILLIS_PRINTER = new DateTimeFormatterBuilder().append(DateFormatters.STRICT_DATE.printer).appendLiteral('T').append(DateFormatters.STRICT_HOUR_MINUTE.printer).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NOT_NEGATIVE).appendZoneId().toFormatter(Locale.ROOT);
        DATE_TIME_PREFIX = new DateTimeFormatterBuilder().append(DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalEnd().toFormatter(Locale.ROOT);
        DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(DATE_TIME_NO_MILLIS_PRINTER, new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(DATE_TIME_PREFIX).optionalStart().append(TIME_ZONE_FORMATTER_NO_COLON).optionalEnd().toFormatter(Locale.ROOT));
        HOUR_MINUTE_SECOND_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_HOUR_MINUTE_SECOND_FRACTION.printer, HOUR_MINUTE_SECOND_MILLIS_FORMATTER);
        HOUR_MINUTE = new CompoundDateTimeFormatter(DateFormatters.STRICT_HOUR_MINUTE.printer, HOUR_MINUTE_FORMATTER);
        HOUR_MINUTE_SECOND = new CompoundDateTimeFormatter(DateFormatters.STRICT_HOUR_MINUTE_SECOND.printer, new DateTimeFormatterBuilder().append(HOUR_MINUTE_FORMATTER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        HOUR = new CompoundDateTimeFormatter(DateFormatters.STRICT_HOUR.printer, new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter(Locale.ROOT));
        ORDINAL_DATE_TIME_FORMATTER_BASE = new DateTimeFormatterBuilder().append(ORDINAL_DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_FORMATTER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().toFormatter(Locale.ROOT);
        ORDINAL_DATE_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_ORDINAL_DATE_TIME.printer, new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_FORMATTER_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_FORMATTER_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        ORDINAL_DATE_TIME_NO_MILLIS_BASE = new DateTimeFormatterBuilder().append(ORDINAL_DATE_FORMATTER).appendLiteral('T').append(HOUR_MINUTE_SECOND_FORMATTER).toFormatter(Locale.ROOT);
        ORDINAL_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_ORDINAL_DATE_TIME_NO_MILLIS.printer, new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(ORDINAL_DATE_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        WEEK_DATE_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_WEEK_DATE_TIME.printer, new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).appendLiteral("T").append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).appendLiteral("T").append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        WEEK_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_WEEK_DATE_TIME_NO_MILLIS.printer, new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).append(T_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(WEEK_DATE_FORMATTER).append(T_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_BASIC_WEEK_DATE_TIME.printer, new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).append(BASIC_T_TIME_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).append(BASIC_T_TIME_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        BASIC_WEEK_DATE_TIME_NO_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_BASIC_WEEK_DATE_TIME_NO_MILLIS.printer, new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(BASIC_WEEK_DATE_FORMATTER).appendLiteral("T").append(BASIC_TIME_NO_MILLIS_BASE).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_TIME.printer, new DateTimeFormatterBuilder().append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        TIME_NO_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_TIME_NO_MILLIS.printer, new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        T_TIME = new CompoundDateTimeFormatter(DateFormatters.STRICT_T_TIME.printer, new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_PREFIX).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().appendLiteral("T").append(TIME_PREFIX).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        T_TIME_NO_MILLIS = new CompoundDateTimeFormatter(DateFormatters.STRICT_T_TIME_NO_MILLIS.printer, new DateTimeFormatterBuilder().append(T_TIME_NO_MILLIS_FORMATTER).appendZoneOrOffsetId().toFormatter(Locale.ROOT), new DateTimeFormatterBuilder().append(T_TIME_NO_MILLIS_FORMATTER).append(TIME_ZONE_FORMATTER_NO_COLON).toFormatter(Locale.ROOT));
        YEAR_MONTH = new CompoundDateTimeFormatter(DateFormatters.STRICT_YEAR_MONTH.printer, new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).toFormatter(Locale.ROOT));
        YEAR_MONTH_DAY = new CompoundDateTimeFormatter(DateFormatters.STRICT_YEAR_MONTH_DAY.printer, new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH).toFormatter(Locale.ROOT));
        WEEK_DATE = new CompoundDateTimeFormatter(DateFormatters.STRICT_WEEK_DATE.printer, WEEK_DATE_FORMATTER);
        WEEKYEAR_WEEK = new CompoundDateTimeFormatter(DateFormatters.STRICT_WEEKYEAR_WEEK.printer, new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear()).toFormatter(Locale.ROOT));
        WEEKYEAR_WEEK_DAY = new CompoundDateTimeFormatter(DateFormatters.STRICT_WEEKYEAR_WEEK_DAY.printer, new DateTimeFormatterBuilder().appendValue(WeekFields.ISO.weekBasedYear()).appendLiteral("-W").appendValue(WeekFields.ISO.weekOfWeekBasedYear()).appendLiteral("-").appendValue(WeekFields.ISO.dayOfWeek()).toFormatter(Locale.ROOT));
        EPOCH_ZONED_DATE_TIME = Instant.EPOCH.atZone(ZoneOffset.UTC);
    }
}

