/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.internal.InternalSearchResponse;

final class ExpandSearchPhase
extends SearchPhase {
    private final SearchPhaseContext context;
    private final InternalSearchResponse searchResponse;
    private final Function<InternalSearchResponse, SearchPhase> nextPhaseFactory;

    ExpandSearchPhase(SearchPhaseContext context, InternalSearchResponse searchResponse, Function<InternalSearchResponse, SearchPhase> nextPhaseFactory) {
        super("expand");
        this.context = context;
        this.searchResponse = searchResponse;
        this.nextPhaseFactory = nextPhaseFactory;
    }

    private boolean isCollapseRequest() {
        SearchRequest searchRequest = this.context.getRequest();
        return searchRequest.source() != null && searchRequest.source().collapse() != null && !searchRequest.source().collapse().getInnerHits().isEmpty();
    }

    @Override
    public void run() throws IOException {
        if (this.isCollapseRequest() && this.searchResponse.hits().getHits().length > 0) {
            SearchRequest searchRequest = this.context.getRequest();
            CollapseBuilder collapseBuilder = searchRequest.source().collapse();
            List<InnerHitBuilder> innerHitBuilders = collapseBuilder.getInnerHits();
            MultiSearchRequest multiRequest = new MultiSearchRequest();
            if (collapseBuilder.getMaxConcurrentGroupRequests() > 0) {
                multiRequest.maxConcurrentSearchRequests(collapseBuilder.getMaxConcurrentGroupRequests());
            }
            for (SearchHit hit : this.searchResponse.hits().getHits()) {
                BoolQueryBuilder groupQuery = new BoolQueryBuilder();
                Object collapseValue = hit.field(collapseBuilder.getField()).getValue();
                if (collapseValue != null) {
                    groupQuery.filter(QueryBuilders.matchQuery(collapseBuilder.getField(), collapseValue));
                } else {
                    groupQuery.mustNot(QueryBuilders.existsQuery(collapseBuilder.getField()));
                }
                QueryBuilder origQuery = searchRequest.source().query();
                if (origQuery != null) {
                    groupQuery.must(origQuery);
                }
                for (InnerHitBuilder innerHitBuilder : innerHitBuilders) {
                    CollapseBuilder innerCollapseBuilder = innerHitBuilder.getInnerCollapseBuilder();
                    SearchSourceBuilder sourceBuilder = this.buildExpandSearchSourceBuilder(innerHitBuilder, innerCollapseBuilder).query(groupQuery).postFilter(searchRequest.source().postFilter());
                    SearchRequest groupRequest = this.buildExpandSearchRequest(searchRequest, sourceBuilder);
                    multiRequest.add(groupRequest);
                }
            }
            this.context.getSearchTransport().sendExecuteMultiSearch(multiRequest, this.context.getTask(), ActionListener.wrap(response -> {
                Iterator<MultiSearchResponse.Item> it = response.iterator();
                for (SearchHit hit : this.searchResponse.hits.getHits()) {
                    for (InnerHitBuilder innerHitBuilder : innerHitBuilders) {
                        MultiSearchResponse.Item item = it.next();
                        if (item.isFailure()) {
                            this.context.onPhaseFailure(this, "failed to expand hits", item.getFailure());
                            return;
                        }
                        SearchHits innerHits = item.getResponse().getHits();
                        if (hit.getInnerHits() == null) {
                            hit.setInnerHits(new HashMap<String, SearchHits>(innerHitBuilders.size()));
                        }
                        hit.getInnerHits().put(innerHitBuilder.getName(), innerHits);
                    }
                }
                this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.searchResponse));
            }, this.context::onFailure));
        } else {
            this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.searchResponse));
        }
    }

    private SearchRequest buildExpandSearchRequest(SearchRequest orig, SearchSourceBuilder sourceBuilder) {
        SearchRequest groupRequest = new SearchRequest(orig.indices()).types(orig.types()).source(sourceBuilder).indicesOptions(orig.indicesOptions()).requestCache(orig.requestCache()).preference(orig.preference()).routing(orig.routing()).searchType(orig.searchType());
        if (orig.allowPartialSearchResults() != null) {
            groupRequest.allowPartialSearchResults(orig.allowPartialSearchResults());
        }
        if (orig.isMaxConcurrentShardRequestsSet()) {
            groupRequest.setMaxConcurrentShardRequests(orig.getMaxConcurrentShardRequests());
        }
        return groupRequest;
    }

    private SearchSourceBuilder buildExpandSearchSourceBuilder(InnerHitBuilder options, CollapseBuilder innerCollapseBuilder) {
        SearchSourceBuilder groupSource = new SearchSourceBuilder();
        groupSource.from(options.getFrom());
        groupSource.size(options.getSize());
        if (options.getSorts() != null) {
            options.getSorts().forEach(groupSource::sort);
        }
        if (options.getFetchSourceContext() != null) {
            if (options.getFetchSourceContext().includes() == null && options.getFetchSourceContext().excludes() == null) {
                groupSource.fetchSource(options.getFetchSourceContext().fetchSource());
            } else {
                groupSource.fetchSource(options.getFetchSourceContext().includes(), options.getFetchSourceContext().excludes());
            }
        }
        if (options.getDocValueFields() != null) {
            options.getDocValueFields().forEach(ff -> groupSource.docValueField(ff.field, ff.format));
        }
        if (options.getStoredFieldsContext() != null && options.getStoredFieldsContext().fieldNames() != null) {
            options.getStoredFieldsContext().fieldNames().forEach(groupSource::storedField);
        }
        if (options.getScriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : options.getScriptFields()) {
                groupSource.scriptField(field.fieldName(), field.script());
            }
        }
        if (options.getHighlightBuilder() != null) {
            groupSource.highlighter(options.getHighlightBuilder());
        }
        groupSource.explain(options.isExplain());
        groupSource.trackScores(options.isTrackScores());
        groupSource.version(options.isVersion());
        if (innerCollapseBuilder != null) {
            groupSource.collapse(innerCollapseBuilder);
        }
        return groupSource;
    }
}

