/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryComparison;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Range
extends Expression {
    private final Expression value;
    private final Expression lower;
    private final Expression upper;
    private final boolean includeLower;
    private final boolean includeUpper;

    public Range(Location location, Expression value, Expression lower, boolean includeLower, Expression upper, boolean includeUpper) {
        super(location, Arrays.asList(value, lower, upper));
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    protected NodeInfo<Range> info() {
        return NodeInfo.create(this, Range::new, this.value, this.lower, this.includeLower, this.upper, this.includeUpper);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Range(this.location(), newChildren.get(0), newChildren.get(1), this.includeLower, newChildren.get(2), this.includeUpper);
    }

    public Expression value() {
        return this.value;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    @Override
    public boolean foldable() {
        if (this.lower.foldable() && this.upper.foldable()) {
            return this.areBoundariesInvalid() || this.value.foldable();
        }
        return false;
    }

    @Override
    public Object fold() {
        boolean lowerComparsion;
        if (this.areBoundariesInvalid()) {
            return Boolean.FALSE;
        }
        Object val = this.value.fold();
        Integer lowerCompare = BinaryComparison.compare(this.lower.fold(), val);
        Integer upperCompare = BinaryComparison.compare(val, this.upper().fold());
        boolean bl = lowerCompare == null ? false : (this.includeLower ? lowerCompare <= 0 : (lowerComparsion = lowerCompare < 0));
        boolean upperComparsion = upperCompare == null ? false : (this.includeUpper ? upperCompare <= 0 : upperCompare < 0);
        return lowerComparsion && upperComparsion;
    }

    private boolean areBoundariesInvalid() {
        Integer compare = BinaryComparison.compare(this.lower.fold(), this.upper.fold());
        return compare != null && (compare > 0 || compare == 0 && (!this.includeLower || !this.includeUpper));
    }

    @Override
    public boolean nullable() {
        return this.value.nullable() && this.lower.nullable() && this.upper.nullable();
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.includeLower, this.includeUpper, this.value, this.lower, this.upper);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.value, other.value) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lower);
        sb.append(this.includeLower ? " <= " : " < ");
        sb.append(this.value);
        sb.append(this.includeUpper ? " <= " : " < ");
        sb.append(this.upper);
        return sb.toString();
    }
}

