/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.DocValuesNumbersQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

class FieldExtractor {
    FieldExtractor() {
    }

    static void extractFields(Query query, Set<String> fields) throws UnsupportedOperationException {
        if (query instanceof BooleanQuery) {
            BooleanQuery q = (BooleanQuery)query;
            for (BooleanClause clause : q.clauses()) {
                FieldExtractor.extractFields(clause.getQuery(), fields);
            }
        } else if (query instanceof DisjunctionMaxQuery) {
            DisjunctionMaxQuery q = (DisjunctionMaxQuery)query;
            for (Query clause : q.getDisjuncts()) {
                FieldExtractor.extractFields(clause, fields);
            }
        } else if (query instanceof SpanTermQuery) {
            fields.add(((SpanTermQuery)query).getField());
        } else if (query instanceof TermQuery) {
            fields.add(((TermQuery)query).getTerm().field());
        } else if (query instanceof SynonymQuery) {
            SynonymQuery q = (SynonymQuery)query;
            fields.add(((Term)q.getTerms().get(0)).field());
        } else if (query instanceof PhraseQuery) {
            PhraseQuery q = (PhraseQuery)query;
            fields.add(q.getTerms()[0].field());
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery q = (MultiPhraseQuery)query;
            fields.add(q.getTermArrays()[0][0].field());
        } else if (query instanceof PointRangeQuery) {
            fields.add(((PointRangeQuery)query).getField());
        } else if (query instanceof PointInSetQuery) {
            fields.add(((PointInSetQuery)query).getField());
        } else if (query instanceof DocValuesFieldExistsQuery) {
            fields.add(((DocValuesFieldExistsQuery)query).getField());
        } else if (query instanceof DocValuesNumbersQuery) {
            fields.add(((DocValuesNumbersQuery)query).getField());
        } else if (query instanceof IndexOrDocValuesQuery) {
            try {
                HashSet<String> dvQueryFields = new HashSet<String>(1);
                FieldExtractor.extractFields(((IndexOrDocValuesQuery)query).getRandomAccessQuery(), dvQueryFields);
                fields.addAll(dvQueryFields);
            }
            catch (UnsupportedOperationException e) {
                FieldExtractor.extractFields(((IndexOrDocValuesQuery)query).getIndexQuery(), fields);
            }
        } else if (query instanceof TermInSetQuery) {
            TermInSetQuery termInSetQuery = (TermInSetQuery)query;
            PrefixCodedTerms.TermIterator termIterator = termInSetQuery.getTermData().iterator();
            if (termIterator.next() != null) {
                fields.add(termIterator.field());
            }
        } else if (!(query instanceof MatchAllDocsQuery) && !(query instanceof MatchNoDocsQuery)) {
            throw new UnsupportedOperationException();
        }
    }
}

