/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.Mode;

public class SqlClearCursorRequest
extends AbstractSqlRequest {
    private static final ConstructingObjectParser<SqlClearCursorRequest, Mode> PARSER = new ConstructingObjectParser<SqlClearCursorRequest, Mode>("indices:data/read/sql/close_cursor", true, (objects, mode) -> new SqlClearCursorRequest((Mode)((Object)mode), (String)objects[0]));
    private String cursor;

    public SqlClearCursorRequest() {
    }

    public SqlClearCursorRequest(Mode mode, String cursor) {
        super(mode);
        this.cursor = cursor;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.getCursor() == null) {
            validationException = ValidateActions.addValidationError("cursor is required", validationException);
        }
        return validationException;
    }

    public String getCursor() {
        return this.cursor;
    }

    public SqlClearCursorRequest setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Override
    public String getDescription() {
        return "SQL Clean cursor [" + this.getCursor() + "]";
    }

    public SqlClearCursorRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlClearCursorRequest that = (SqlClearCursorRequest)o;
        return Objects.equals(this.cursor, that.cursor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return new org.elasticsearch.xpack.sql.proto.SqlClearCursorRequest(this.mode(), this.cursor).toXContent(builder, params);
    }

    public static SqlClearCursorRequest fromXContent(XContentParser parser, Mode mode) {
        return PARSER.apply(parser, mode);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("cursor", new String[0]));
    }
}

