/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;

public final class PainlessLookup {
    private final Map<String, Class<?>> canonicalClassNamesToClasses;
    private final Map<Class<?>, PainlessClass> classesToPainlessClasses;

    public Collection<PainlessClass> getStructs() {
        return this.classesToPainlessClasses.values();
    }

    PainlessLookup(Map<String, Class<?>> canonicalClassNamesToClasses, Map<Class<?>, PainlessClass> classesToPainlessClasses) {
        this.canonicalClassNamesToClasses = Collections.unmodifiableMap(canonicalClassNamesToClasses);
        this.classesToPainlessClasses = Collections.unmodifiableMap(classesToPainlessClasses);
    }

    public Class<?> getClassFromBinaryName(String painlessType) {
        return this.canonicalClassNamesToClasses.get(painlessType.replace('$', '.'));
    }

    public boolean isSimplePainlessType(String painlessType) {
        return this.canonicalClassNamesToClasses.containsKey(painlessType);
    }

    public PainlessClass getPainlessStructFromJavaClass(Class<?> clazz) {
        return this.classesToPainlessClasses.get(clazz);
    }

    public Class<?> getJavaClassFromPainlessType(String painlessType) {
        return PainlessLookupUtility.canonicalTypeNameToType(painlessType, this.canonicalClassNamesToClasses);
    }
}

