/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.Params;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class ScalarFunction
extends Function {
    private ScalarFunctionAttribute lazyAttribute = null;
    private ProcessorDefinition lazyProcessor = null;

    protected ScalarFunction(Location location) {
        super(location, Collections.emptyList());
    }

    protected ScalarFunction(Location location, List<Expression> fields) {
        super(location, fields);
    }

    @Override
    public final ScalarFunctionAttribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = new ScalarFunctionAttribute(this.location(), this.name(), this.dataType(), this.id(), this.functionId(), this.asScript(), this.orderBy(), this.asProcessorDefinition());
        }
        return this.lazyAttribute;
    }

    public abstract ScriptTemplate asScript();

    protected ScriptTemplate asScript(Expression exp) {
        if (exp.foldable()) {
            return this.asScriptFromFoldable(exp);
        }
        Attribute attr = Expressions.attribute(exp);
        if (attr != null) {
            if (attr instanceof ScalarFunctionAttribute) {
                return this.asScriptFrom((ScalarFunctionAttribute)attr);
            }
            if (attr instanceof AggregateFunctionAttribute) {
                return this.asScriptFrom((AggregateFunctionAttribute)attr);
            }
            return this.asScriptFrom((FieldAttribute)attr);
        }
        throw new SqlIllegalArgumentException("Cannot evaluate script for expression {}", exp);
    }

    protected ScriptTemplate asScriptFrom(ScalarFunctionAttribute scalar) {
        ScriptTemplate nested = scalar.script();
        Params p = ParamsBuilder.paramsBuilder().script(nested.params()).build();
        return new ScriptTemplate(this.formatScript(nested.template()), p, this.dataType());
    }

    protected ScriptTemplate asScriptFromFoldable(Expression foldable) {
        return new ScriptTemplate(this.formatScript("{}"), ParamsBuilder.paramsBuilder().variable(foldable.fold()).build(), foldable.dataType());
    }

    protected ScriptTemplate asScriptFrom(FieldAttribute field) {
        return new ScriptTemplate(this.formatScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.name()).build(), field.dataType());
    }

    protected ScriptTemplate asScriptFrom(AggregateFunctionAttribute aggregate) {
        return new ScriptTemplate(this.formatScript("{}"), ParamsBuilder.paramsBuilder().agg(aggregate).build(), aggregate.dataType());
    }

    protected String formatScript(String scriptTemplate) {
        return ScriptTemplate.formatTemplate(scriptTemplate);
    }

    public ProcessorDefinition asProcessorDefinition() {
        if (this.lazyProcessor == null) {
            this.lazyProcessor = this.makeProcessorDefinition();
        }
        return this.lazyProcessor;
    }

    protected abstract ProcessorDefinition makeProcessorDefinition();

    public Expression orderBy() {
        return null;
    }
}

