/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Percentile
extends NumericAggregate
implements EnclosedAgg {
    private final Expression percent;

    public Percentile(Location location, Expression field, Expression percent) {
        super(location, field, Collections.singletonList(percent));
        this.percent = percent;
    }

    @Override
    protected NodeInfo<Percentile> info() {
        return NodeInfo.create(this, Percentile::new, this.field(), this.percent);
    }

    @Override
    public Percentile replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new Percentile(this.location(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (Expression.TypeResolution.TYPE_RESOLVED.equals(resolution)) {
            resolution = Expressions.typeMustBeNumeric(this.percent());
        }
        return resolution;
    }

    public Expression percent() {
        return this.percent;
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public String innerName() {
        return Double.toString(Foldables.doubleValueOf(this.percent));
    }
}

