/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.type.DataType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class FieldHitExtractor
implements HitExtractor {
    private static final boolean ARRAYS_LENIENCY = false;
    static final String NAME = "f";
    private final String fieldName;
    private final String hitName;
    private final DataType dataType;
    private final boolean useDocValue;
    private final String[] path;

    private static String[] sourcePath(String name, boolean useDocValue, String hitName) {
        return useDocValue ? Strings.EMPTY_ARRAY : Strings.tokenizeToStringArray((String)(hitName == null ? name : name.substring(hitName.length() + 1)), (String)".");
    }

    public FieldHitExtractor(String name, DataType dataType, boolean useDocValue) {
        this(name, dataType, useDocValue, null);
    }

    public FieldHitExtractor(String name, DataType dataType, boolean useDocValue, String hitName) {
        this.fieldName = name;
        this.dataType = dataType;
        this.useDocValue = useDocValue;
        this.hitName = hitName;
        if (hitName != null && !name.contains(hitName)) {
            throw new SqlIllegalArgumentException("Hitname [{}] specified but not part of the name [{}]", hitName, name);
        }
        this.path = FieldHitExtractor.sourcePath(this.fieldName, useDocValue, hitName);
    }

    FieldHitExtractor(StreamInput in) throws IOException {
        String esType;
        this.fieldName = in.readString();
        this.dataType = in.getVersion().onOrAfter(Version.V_6_4_0) ? ((esType = in.readOptionalString()) != null ? DataType.fromEsType((String)esType) : null) : null;
        this.useDocValue = in.readBoolean();
        this.hitName = in.readOptionalString();
        this.path = FieldHitExtractor.sourcePath(this.fieldName, this.useDocValue, this.hitName);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalString(this.dataType == null ? null : this.dataType.esType);
        }
        out.writeBoolean(this.useDocValue);
        out.writeOptionalString(this.hitName);
    }

    @Override
    public Object extract(SearchHit hit) {
        Object value = null;
        if (this.useDocValue) {
            DocumentField field = hit.field(this.fieldName);
            if (field != null) {
                value = this.unwrapMultiValue(field.getValues());
            }
        } else {
            Map source = hit.getSourceAsMap();
            if (source != null) {
                value = this.extractFromSource(source);
            }
        }
        return value;
    }

    private Object unwrapMultiValue(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return this.unwrapMultiValue(list.get(0));
            }
            throw new SqlIllegalArgumentException("Arrays (returned by [{}]) are not supported", this.fieldName);
        }
        if (values instanceof Map) {
            throw new SqlIllegalArgumentException("Objects (returned by [{}]) are not supported", this.fieldName);
        }
        if (values instanceof String && this.dataType == DataType.DATE) {
            return new DateTime(Long.parseLong(values.toString()), DateTimeZone.UTC);
        }
        if (values instanceof Long || values instanceof Double || values instanceof String || values instanceof Boolean || values instanceof ReadableDateTime) {
            return values;
        }
        throw new SqlIllegalArgumentException("Type {} (returned by [{}]) is not supported", values.getClass().getSimpleName(), this.fieldName);
    }

    Object extractFromSource(Map<String, Object> map) {
        Object value = map;
        boolean first = true;
        for (String node : this.path) {
            if (value == null) {
                return null;
            }
            if (!first && !(value instanceof Map)) {
                throw new SqlIllegalArgumentException("Cannot extract value [{}] from source", this.fieldName);
            }
            first = false;
            value = value.get(node);
        }
        return this.unwrapMultiValue(value);
    }

    @Override
    public String hitName() {
        return this.hitName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName + "@" + this.hitName;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldHitExtractor other = (FieldHitExtractor)obj;
        return this.fieldName.equals(other.fieldName) && this.hitName.equals(other.hitName) && this.useDocValue == other.useDocValue;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.useDocValue, this.hitName);
    }
}

