/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.translog.ChannelFactory;

final class Checkpoint {
    final long offset;
    final int numOps;
    final long generation;
    final long minSeqNo;
    final long maxSeqNo;
    final long globalCheckpoint;
    final long minTranslogGeneration;
    final long trimmedAboveSeqNo;
    private static final int INITIAL_VERSION = 1;
    private static final int VERSION_6_0_0 = 2;
    private static final int CURRENT_VERSION = 3;
    private static final String CHECKPOINT_CODEC = "ckp";
    static final int V3_FILE_SIZE = CodecUtil.headerLength((String)"ckp") + 4 + 8 + 8 + 8 + 8 + 8 + 8 + 8 + CodecUtil.footerLength();
    static final int V2_FILE_SIZE = CodecUtil.headerLength((String)"ckp") + 4 + 8 + 8 + 8 + 8 + 8 + 8 + CodecUtil.footerLength();
    static final int V1_FILE_SIZE = CodecUtil.headerLength((String)"ckp") + 4 + 8 + 8 + CodecUtil.footerLength();

    Checkpoint(long offset, int numOps, long generation, long minSeqNo, long maxSeqNo, long globalCheckpoint, long minTranslogGeneration, long trimmedAboveSeqNo) {
        assert (minSeqNo <= maxSeqNo) : "minSeqNo [" + minSeqNo + "] is higher than maxSeqNo [" + maxSeqNo + "]";
        assert (trimmedAboveSeqNo <= maxSeqNo) : "trimmedAboveSeqNo [" + trimmedAboveSeqNo + "] is higher than maxSeqNo [" + maxSeqNo + "]";
        assert (minTranslogGeneration <= generation) : "minTranslogGen [" + minTranslogGeneration + "] is higher than generation [" + generation + "]";
        this.offset = offset;
        this.numOps = numOps;
        this.generation = generation;
        this.minSeqNo = minSeqNo;
        this.maxSeqNo = maxSeqNo;
        this.globalCheckpoint = globalCheckpoint;
        this.minTranslogGeneration = minTranslogGeneration;
        this.trimmedAboveSeqNo = trimmedAboveSeqNo;
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        out.writeInt(this.numOps);
        out.writeLong(this.generation);
        out.writeLong(this.minSeqNo);
        out.writeLong(this.maxSeqNo);
        out.writeLong(this.globalCheckpoint);
        out.writeLong(this.minTranslogGeneration);
        out.writeLong(this.trimmedAboveSeqNo);
    }

    static Checkpoint emptyTranslogCheckpoint(long offset, long generation, long globalCheckpoint, long minTranslogGeneration) {
        long minSeqNo = -1L;
        long maxSeqNo = -1L;
        long trimmedAboveSeqNo = -2L;
        return new Checkpoint(offset, 0, generation, -1L, -1L, globalCheckpoint, minTranslogGeneration, -2L);
    }

    static Checkpoint readCheckpointV6_4_0(DataInput in) throws IOException {
        long offset = in.readLong();
        int numOps = in.readInt();
        long generation = in.readLong();
        long minSeqNo = in.readLong();
        long maxSeqNo = in.readLong();
        long globalCheckpoint = in.readLong();
        long minTranslogGeneration = in.readLong();
        long trimmedAboveSeqNo = in.readLong();
        return new Checkpoint(offset, numOps, generation, minSeqNo, maxSeqNo, globalCheckpoint, minTranslogGeneration, trimmedAboveSeqNo);
    }

    static Checkpoint readCheckpointV6_0_0(DataInput in) throws IOException {
        long offset = in.readLong();
        int numOps = in.readInt();
        long generation = in.readLong();
        long minSeqNo = in.readLong();
        long maxSeqNo = in.readLong();
        long globalCheckpoint = in.readLong();
        long minTranslogGeneration = in.readLong();
        long trimmedAboveSeqNo = -2L;
        return new Checkpoint(offset, numOps, generation, minSeqNo, maxSeqNo, globalCheckpoint, minTranslogGeneration, -2L);
    }

    static Checkpoint readCheckpointV5_0_0(DataInput in) throws IOException {
        long offset = in.readLong();
        int numOps = in.readInt();
        long generation = in.readLong();
        long minSeqNo = -1L;
        long maxSeqNo = -1L;
        long globalCheckpoint = -2L;
        long minTranslogGeneration = -1L;
        long trimmedAboveSeqNo = -2L;
        return new Checkpoint(offset, numOps, generation, -1L, -1L, -2L, -1L, -2L);
    }

    public String toString() {
        return "Checkpoint{offset=" + this.offset + ", numOps=" + this.numOps + ", generation=" + this.generation + ", minSeqNo=" + this.minSeqNo + ", maxSeqNo=" + this.maxSeqNo + ", globalCheckpoint=" + this.globalCheckpoint + ", minTranslogGeneration=" + this.minTranslogGeneration + ", trimmedAboveSeqNo=" + this.trimmedAboveSeqNo + '}';
    }

    /*
     * Exception decompiling
     */
    public static Checkpoint read(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(ChannelFactory factory, Path checkpointFile, Checkpoint checkpoint, OpenOption ... options) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(V3_FILE_SIZE){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        String resourceDesc = "checkpoint(path=\"" + checkpointFile + "\", gen=" + checkpoint + ")";
        try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, checkpointFile.toString(), (OutputStream)byteOutputStream, V3_FILE_SIZE);){
            CodecUtil.writeHeader((DataOutput)indexOutput, (String)CHECKPOINT_CODEC, (int)3);
            checkpoint.write((DataOutput)indexOutput);
            CodecUtil.writeFooter((IndexOutput)indexOutput);
            assert (indexOutput.getFilePointer() == (long)V3_FILE_SIZE) : "get you numbers straight; bytes written: " + indexOutput.getFilePointer() + ", buffer size: " + V3_FILE_SIZE;
            assert (indexOutput.getFilePointer() < 512L) : "checkpoint files have to be smaller than 512 bytes for atomic writes; size: " + indexOutput.getFilePointer();
        }
        var7_7 = null;
        try (FileChannel channel = factory.open(checkpointFile, options);){
            Channels.writeToChannel(byteOutputStream.toByteArray(), (WritableByteChannel)channel);
            channel.force(false);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.numOps != that.numOps) {
            return false;
        }
        if (this.generation != that.generation) {
            return false;
        }
        if (this.minSeqNo != that.minSeqNo) {
            return false;
        }
        if (this.maxSeqNo != that.maxSeqNo) {
            return false;
        }
        if (this.globalCheckpoint != that.globalCheckpoint) {
            return false;
        }
        return this.trimmedAboveSeqNo == that.trimmedAboveSeqNo;
    }

    public int hashCode() {
        int result = Long.hashCode(this.offset);
        result = 31 * result + this.numOps;
        result = 31 * result + Long.hashCode(this.generation);
        result = 31 * result + Long.hashCode(this.minSeqNo);
        result = 31 * result + Long.hashCode(this.maxSeqNo);
        result = 31 * result + Long.hashCode(this.globalCheckpoint);
        result = 31 * result + Long.hashCode(this.trimmedAboveSeqNo);
        return result;
    }
}

