/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions.js;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptBaseVisitor;
import org.apache.lucene.expressions.js.JavascriptErrorHandlingLexer;
import org.apache.lucene.expressions.js.JavascriptParser;
import org.apache.lucene.expressions.js.JavascriptParserErrorStrategy;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.util.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class JavascriptCompiler {
    private static final int CLASSFILE_VERSION = 52;
    private static final String COMPILED_EXPRESSION_CLASS = JavascriptCompiler.class.getName() + "$CompiledExpression";
    private static final String COMPILED_EXPRESSION_INTERNAL = COMPILED_EXPRESSION_CLASS.replace('.', '/');
    static final Type EXPRESSION_TYPE = Type.getType(Expression.class);
    static final Type FUNCTION_VALUES_TYPE = Type.getType(DoubleValues.class);
    private static final Method EXPRESSION_CTOR = JavascriptCompiler.getAsmMethod(Void.TYPE, "<init>", String.class, String[].class);
    private static final Method EVALUATE_METHOD = JavascriptCompiler.getAsmMethod(Double.TYPE, "evaluate", DoubleValues[].class);
    static final Method DOUBLE_VAL_METHOD = JavascriptCompiler.getAsmMethod(Double.TYPE, "doubleValue", new Class[0]);
    private static final int MAX_SOURCE_LENGTH = 16384;
    final String sourceText;
    final Map<String, java.lang.reflect.Method> functions;
    public static final Map<String, java.lang.reflect.Method> DEFAULT_FUNCTIONS;

    private static Method getAsmMethod(Class<?> rtype, String name, Class<?> ... ptypes) {
        return new Method(name, MethodType.methodType(rtype, ptypes).toMethodDescriptorString());
    }

    public static Expression compile(String sourceText) throws ParseException {
        return new JavascriptCompiler(sourceText).compileExpression(JavascriptCompiler.class.getClassLoader());
    }

    public static Expression compile(String sourceText, Map<String, java.lang.reflect.Method> functions, ClassLoader parent) throws ParseException {
        if (parent == null) {
            throw new NullPointerException("A parent ClassLoader must be given.");
        }
        for (java.lang.reflect.Method m : functions.values()) {
            JavascriptCompiler.checkFunctionClassLoader(m, parent);
            JavascriptCompiler.checkFunction(m);
        }
        return new JavascriptCompiler(sourceText, functions).compileExpression(parent);
    }

    private static void unusedTestCompile() throws IOException {
        Object f = null;
        double ret = f.doubleValue();
    }

    private JavascriptCompiler(String sourceText) {
        this(sourceText, DEFAULT_FUNCTIONS);
    }

    private JavascriptCompiler(String sourceText, Map<String, java.lang.reflect.Method> functions) {
        if (sourceText == null) {
            throw new NullPointerException();
        }
        this.sourceText = sourceText;
        this.functions = functions;
    }

    private Expression compileExpression(ClassLoader parent) throws ParseException {
        LinkedHashMap<String, Integer> externalsMap = new LinkedHashMap<String, Integer>();
        ClassWriter classWriter = new ClassWriter(3);
        try {
            this.generateClass(this.getAntlrParseTree(), classWriter, externalsMap);
            Class<? extends Expression> evaluatorClass = new Loader(parent).define(COMPILED_EXPRESSION_CLASS, classWriter.toByteArray());
            Constructor<? extends Expression> constructor = evaluatorClass.getConstructor(String.class, String[].class);
            return constructor.newInstance(this.sourceText, externalsMap.keySet().toArray(new String[externalsMap.size()]));
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
    }

    private ParseTree getAntlrParseTree() throws ParseException {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(this.sourceText);
        JavascriptErrorHandlingLexer javascriptLexer = new JavascriptErrorHandlingLexer((CharStream)antlrInputStream);
        javascriptLexer.removeErrorListeners();
        JavascriptParser javascriptParser = new JavascriptParser((TokenStream)new CommonTokenStream((TokenSource)javascriptLexer));
        javascriptParser.removeErrorListeners();
        javascriptParser.setErrorHandler((ANTLRErrorStrategy)new JavascriptParserErrorStrategy());
        return javascriptParser.compile();
    }

    private void generateClass(ParseTree parseTree, ClassWriter classWriter, final Map<String, Integer> externalsMap) throws ParseException {
        classWriter.visit(52, 49, COMPILED_EXPRESSION_INTERNAL, null, EXPRESSION_TYPE.getInternalName(), null);
        String clippedSourceText = this.sourceText.length() <= 16384 ? this.sourceText : this.sourceText.substring(0, 16381) + "...";
        classWriter.visitSource(clippedSourceText, null);
        GeneratorAdapter constructor = new GeneratorAdapter(1, EXPRESSION_CTOR, null, null, (ClassVisitor)classWriter);
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(EXPRESSION_TYPE, EXPRESSION_CTOR);
        constructor.returnValue();
        constructor.endMethod();
        final GeneratorAdapter gen = new GeneratorAdapter(1, EVALUATE_METHOD, null, null, (ClassVisitor)classWriter);
        new JavascriptBaseVisitor<Void>(){
            private final Deque<Type> typeStack = new ArrayDeque<Type>();

            @Override
            public Void visitCompile(JavascriptParser.CompileContext ctx) {
                this.typeStack.push(Type.DOUBLE_TYPE);
                this.visit((ParseTree)ctx.expression());
                this.typeStack.pop();
                return null;
            }

            @Override
            public Void visitPrecedence(JavascriptParser.PrecedenceContext ctx) {
                this.visit((ParseTree)ctx.expression());
                return null;
            }

            @Override
            public Void visitNumeric(JavascriptParser.NumericContext ctx) {
                if (ctx.HEX() != null) {
                    this.pushLong(Long.parseLong(ctx.HEX().getText().substring(2), 16));
                } else if (ctx.OCTAL() != null) {
                    this.pushLong(Long.parseLong(ctx.OCTAL().getText().substring(1), 8));
                } else if (ctx.DECIMAL() != null) {
                    gen.push(Double.parseDouble(ctx.DECIMAL().getText()));
                    gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                return null;
            }

            @Override
            public Void visitExternal(JavascriptParser.ExternalContext ctx) {
                String text = ctx.VARIABLE().getText();
                int arguments = ctx.expression().size();
                boolean parens = ctx.LP() != null && ctx.RP() != null;
                java.lang.reflect.Method method = parens ? JavascriptCompiler.this.functions.get(text) : null;
                try {
                    if (method != null) {
                        int arity = method.getParameterTypes().length;
                        if (arguments != arity) {
                            throw new ParseException("Invalid expression '" + JavascriptCompiler.this.sourceText + "': Expected (" + arity + ") arguments for function call (" + text + "), but found (" + arguments + ").", ctx.start.getStartIndex());
                        }
                        this.typeStack.push(Type.DOUBLE_TYPE);
                        for (int argument = 0; argument < arguments; ++argument) {
                            this.visit((ParseTree)ctx.expression(argument));
                        }
                        this.typeStack.pop();
                        gen.invokeStatic(Type.getType(method.getDeclaringClass()), Method.getMethod((java.lang.reflect.Method)method));
                        gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                    } else if (!parens || arguments == 0 && text.contains(".")) {
                        int index;
                        text = JavascriptCompiler.normalizeQuotes(ctx.getText());
                        if (externalsMap.containsKey(text)) {
                            index = (Integer)externalsMap.get(text);
                        } else {
                            index = externalsMap.size();
                            externalsMap.put(text, index);
                        }
                        gen.loadArg(0);
                        gen.push(index);
                        gen.arrayLoad(FUNCTION_VALUES_TYPE);
                        gen.invokeVirtual(FUNCTION_VALUES_TYPE, DOUBLE_VAL_METHOD);
                        gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                    } else {
                        throw new ParseException("Invalid expression '" + JavascriptCompiler.this.sourceText + "': Unrecognized function call (" + text + ").", ctx.start.getStartIndex());
                    }
                    return null;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Void visitUnary(JavascriptParser.UnaryContext ctx) {
                if (ctx.BOOLNOT() != null) {
                    Label labelNotTrue = new Label();
                    Label labelNotReturn = new Label();
                    this.typeStack.push(Type.INT_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.visitJumpInsn(153, labelNotTrue);
                    this.pushBoolean(false);
                    gen.goTo(labelNotReturn);
                    gen.visitLabel(labelNotTrue);
                    this.pushBoolean(true);
                    gen.visitLabel(labelNotReturn);
                } else if (ctx.BWNOT() != null) {
                    this.typeStack.push(Type.LONG_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.push(-1L);
                    gen.visitInsn(131);
                    gen.cast(Type.LONG_TYPE, this.typeStack.peek());
                } else if (ctx.ADD() != null) {
                    this.visit((ParseTree)ctx.expression());
                } else if (ctx.SUB() != null) {
                    this.typeStack.push(Type.DOUBLE_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.visitInsn(119);
                    gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                return null;
            }

            @Override
            public Void visitMuldiv(JavascriptParser.MuldivContext ctx) {
                int opcode;
                if (ctx.MUL() != null) {
                    opcode = 107;
                } else if (ctx.DIV() != null) {
                    opcode = 111;
                } else if (ctx.REM() != null) {
                    opcode = 115;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushArith(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitAddsub(JavascriptParser.AddsubContext ctx) {
                int opcode;
                if (ctx.ADD() != null) {
                    opcode = 99;
                } else if (ctx.SUB() != null) {
                    opcode = 103;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushArith(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwshift(JavascriptParser.BwshiftContext ctx) {
                int opcode;
                if (ctx.LSH() != null) {
                    opcode = 121;
                } else if (ctx.RSH() != null) {
                    opcode = 123;
                } else if (ctx.USH() != null) {
                    opcode = 125;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushShift(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBoolcomp(JavascriptParser.BoolcompContext ctx) {
                int opcode;
                if (ctx.LT() != null) {
                    opcode = 155;
                } else if (ctx.LTE() != null) {
                    opcode = 158;
                } else if (ctx.GT() != null) {
                    opcode = 157;
                } else if (ctx.GTE() != null) {
                    opcode = 156;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushCond(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBooleqne(JavascriptParser.BooleqneContext ctx) {
                int opcode;
                if (ctx.EQ() != null) {
                    opcode = 153;
                } else if (ctx.NE() != null) {
                    opcode = 154;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushCond(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwand(JavascriptParser.BwandContext ctx) {
                this.pushBitwise(127, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwxor(JavascriptParser.BwxorContext ctx) {
                this.pushBitwise(131, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwor(JavascriptParser.BworContext ctx) {
                this.pushBitwise(129, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBooland(JavascriptParser.BoolandContext ctx) {
                Label andFalse = new Label();
                Label andEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                gen.visitJumpInsn(153, andFalse);
                this.visit((ParseTree)ctx.expression(1));
                gen.visitJumpInsn(153, andFalse);
                this.typeStack.pop();
                this.pushBoolean(true);
                gen.goTo(andEnd);
                gen.visitLabel(andFalse);
                this.pushBoolean(false);
                gen.visitLabel(andEnd);
                return null;
            }

            @Override
            public Void visitBoolor(JavascriptParser.BoolorContext ctx) {
                Label orTrue = new Label();
                Label orEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                gen.visitJumpInsn(154, orTrue);
                this.visit((ParseTree)ctx.expression(1));
                gen.visitJumpInsn(154, orTrue);
                this.typeStack.pop();
                this.pushBoolean(false);
                gen.goTo(orEnd);
                gen.visitLabel(orTrue);
                this.pushBoolean(true);
                gen.visitLabel(orEnd);
                return null;
            }

            @Override
            public Void visitConditional(JavascriptParser.ConditionalContext ctx) {
                Label condFalse = new Label();
                Label condEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                this.typeStack.pop();
                gen.visitJumpInsn(153, condFalse);
                this.visit((ParseTree)ctx.expression(1));
                gen.goTo(condEnd);
                gen.visitLabel(condFalse);
                this.visit((ParseTree)ctx.expression(2));
                gen.visitLabel(condEnd);
                return null;
            }

            private void pushArith(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE);
            }

            private void pushShift(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE);
            }

            private void pushBitwise(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE);
            }

            private void pushBinaryOp(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right, Type leftType, Type rightType, Type returnType) {
                this.typeStack.push(leftType);
                this.visit((ParseTree)left);
                this.typeStack.pop();
                this.typeStack.push(rightType);
                this.visit((ParseTree)right);
                this.typeStack.pop();
                gen.visitInsn(operator);
                gen.cast(returnType, this.typeStack.peek());
            }

            private void pushCond(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                Label labelTrue = new Label();
                Label labelReturn = new Label();
                this.typeStack.push(Type.DOUBLE_TYPE);
                this.visit((ParseTree)left);
                this.visit((ParseTree)right);
                this.typeStack.pop();
                gen.ifCmp(Type.DOUBLE_TYPE, operator, labelTrue);
                this.pushBoolean(false);
                gen.goTo(labelReturn);
                gen.visitLabel(labelTrue);
                this.pushBoolean(true);
                gen.visitLabel(labelReturn);
            }

            private void pushBoolean(boolean truth) {
                switch (this.typeStack.peek().getSort()) {
                    case 5: {
                        gen.push(truth);
                        break;
                    }
                    case 7: {
                        gen.push(truth ? 1L : 0L);
                        break;
                    }
                    case 8: {
                        gen.push(truth ? 1.0 : 0.0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid expected type: " + this.typeStack.peek());
                    }
                }
            }

            private void pushLong(long i) {
                switch (this.typeStack.peek().getSort()) {
                    case 5: {
                        gen.push((int)i);
                        break;
                    }
                    case 7: {
                        gen.push(i);
                        break;
                    }
                    case 8: {
                        gen.push((double)i);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid expected type: " + this.typeStack.peek());
                    }
                }
            }
        }.visit(parseTree);
        gen.returnValue();
        gen.endMethod();
        classWriter.visitEnd();
    }

    static String normalizeQuotes(String text) {
        StringBuilder out = new StringBuilder(text.length());
        boolean inDoubleQuotes = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                if ((c = text.charAt(++i)) == '\\') {
                    out.append('\\');
                }
            } else if (c == '\'') {
                if (inDoubleQuotes) {
                    out.append('\\');
                } else {
                    int j = JavascriptCompiler.findSingleQuoteStringEnd(text, i);
                    out.append(text, i, j);
                    i = j;
                }
            } else if (c == '\"') {
                c = '\'';
                inDoubleQuotes = !inDoubleQuotes;
            }
            out.append(c);
        }
        return out.toString();
    }

    static int findSingleQuoteStringEnd(String text, int start) {
        ++start;
        while (text.charAt(start) != '\'') {
            if (text.charAt(start) == '\\') {
                ++start;
            }
            ++start;
        }
        return start;
    }

    private static void checkFunction(java.lang.reflect.Method method) {
        MethodType type;
        try {
            type = MethodHandles.publicLookup().unreflect(method).type();
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(method + " is not accessible (declaring class or method not public).");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(method + " is not static.");
        }
        int arity = type.parameterCount();
        for (int arg = 0; arg < arity; ++arg) {
            if (type.parameterType(arg) == Double.TYPE) continue;
            throw new IllegalArgumentException(method + " must take only double parameters.");
        }
        if (type.returnType() != Double.TYPE) {
            throw new IllegalArgumentException(method + " does not return a double.");
        }
    }

    private static void checkFunctionClassLoader(java.lang.reflect.Method method, ClassLoader parent) {
        boolean ok = false;
        try {
            Class<?> clazz = method.getDeclaringClass();
            ok = Class.forName(clazz.getName(), false, parent) == clazz;
        }
        catch (ClassNotFoundException e) {
            ok = false;
        }
        if (!ok) {
            throw new IllegalArgumentException(method + " is not declared by a class which is accessible by the given parent ClassLoader.");
        }
    }

    static {
        HashMap<String, java.lang.reflect.Method> map = new HashMap<String, java.lang.reflect.Method>();
        try {
            Properties props = new Properties();
            try (Reader in = IOUtils.getDecodingReader(JavascriptCompiler.class, (String)(JavascriptCompiler.class.getSimpleName() + ".properties"), (Charset)StandardCharsets.UTF_8);){
                props.load(in);
            }
            for (String call : props.stringPropertyNames()) {
                String[] vals = props.getProperty(call).split(",");
                if (vals.length != 3) {
                    throw new Error("Syntax error while reading Javascript functions from resource");
                }
                Class<?> clazz = Class.forName(vals[0].trim());
                String methodName = vals[1].trim();
                int arity = Integer.parseInt(vals[2].trim());
                Object[] args = new Class[arity];
                Arrays.fill(args, Double.TYPE);
                java.lang.reflect.Method method = clazz.getMethod(methodName, (Class<?>[])args);
                JavascriptCompiler.checkFunction(method);
                map.put(call, method);
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new Error("Cannot resolve function", e);
        }
        DEFAULT_FUNCTIONS = Collections.unmodifiableMap(map);
    }

    static final class Loader
    extends ClassLoader {
        Loader(ClassLoader parent) {
            super(parent);
        }

        public Class<? extends Expression> define(String className, byte[] bytecode) {
            return this.defineClass(className, bytecode, 0, bytecode.length).asSubclass(Expression.class);
        }
    }
}

