/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;

public abstract class ClusterPermission {
    private final ClusterPrivilege privilege;

    ClusterPermission(ClusterPrivilege privilege) {
        this.privilege = privilege;
    }

    public ClusterPrivilege privilege() {
        return this.privilege;
    }

    public abstract boolean check(String var1, TransportRequest var2);

    public static class CompositeClusterPermission
    extends ClusterPermission {
        private final Collection<ClusterPermission> children;

        public CompositeClusterPermission(Collection<ClusterPermission> children) {
            super(CompositeClusterPermission.buildPrivilege(children));
            this.children = children;
        }

        private static ClusterPrivilege buildPrivilege(Collection<ClusterPermission> children) {
            Set<String> names = children.stream().map(ClusterPermission::privilege).map(Privilege::name).flatMap(Collection::stream).collect(Collectors.toSet());
            return ClusterPrivilege.get(names);
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return this.children.stream().anyMatch(p -> p.check(action, request));
        }
    }

    public static class ConditionalClusterPermission
    extends ClusterPermission {
        private final Predicate<String> actionPredicate;
        private final Predicate<TransportRequest> requestPredicate;

        public ConditionalClusterPermission(ConditionalClusterPrivilege conditionalPrivilege) {
            this(conditionalPrivilege.getPrivilege(), conditionalPrivilege.getRequestPredicate());
        }

        public ConditionalClusterPermission(ClusterPrivilege privilege, Predicate<TransportRequest> requestPredicate) {
            super(privilege);
            this.actionPredicate = privilege.predicate();
            this.requestPredicate = requestPredicate;
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return this.actionPredicate.test(action) && this.requestPredicate.test(request);
        }
    }

    public static class SimpleClusterPermission
    extends ClusterPermission {
        public static final SimpleClusterPermission NONE = new SimpleClusterPermission(ClusterPrivilege.NONE);
        private final Predicate<String> predicate;

        SimpleClusterPermission(ClusterPrivilege privilege) {
            super(privilege);
            this.predicate = privilege.predicate();
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return this.predicate.test(action);
        }
    }
}

