/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportPutFilterAction
extends HandledTransportAction<PutFilterAction.Request, PutFilterAction.Response> {
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportPutFilterAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobManager jobManager) {
        super(settings, "cluster:admin/xpack/ml/filters/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutFilterAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(PutFilterAction.Request request, final ActionListener<PutFilterAction.Response> listener) {
        final MlFilter filter = request.getFilter();
        IndexRequest indexRequest = new IndexRequest(".ml-meta", "doc", filter.documentId());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("include_type", "true"));
            indexRequest.source(filter.toXContent(builder, (ToXContent.Params)params));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialise filter with id [" + filter.getId() + "]", e);
        }
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.add(indexRequest);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse indexResponse) {
                TransportPutFilterAction.this.jobManager.updateProcessOnFilterChanged(filter);
                listener.onResponse((Object)new PutFilterAction.Response());
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Error putting filter with id [" + filter.getId() + "]"), (Throwable)e));
            }
        });
    }
}

