/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.DestroyFailedException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.lucene.util.SetOnce;
import org.bouncycastle.operator.OperatorCreationException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.VerificationMode;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class SSLService
extends AbstractComponent {
    private final Map<SSLConfiguration, SSLContextHolder> sslContexts;
    private final SSLConfiguration globalSSLConfiguration;
    private final SetOnce<SSLConfiguration> transportSSLConfiguration = new SetOnce();
    private final Environment env;

    public SSLService(Settings settings, Environment environment) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, DestroyFailedException, KeyStoreException, OperatorCreationException {
        super(settings);
        this.env = environment;
        this.globalSSLConfiguration = new SSLConfiguration(settings.getByPrefix("xpack.ssl."));
        this.sslContexts = this.loadSSLConfigurations();
    }

    private SSLService(Settings settings, Environment environment, SSLConfiguration globalSSLConfiguration, Map<SSLConfiguration, SSLContextHolder> sslContexts) {
        super(settings);
        this.env = environment;
        this.globalSSLConfiguration = globalSSLConfiguration;
        this.sslContexts = sslContexts;
    }

    public SSLService createDynamicSSLService() {
        return new SSLService(this.settings, this.env, this.globalSSLConfiguration, this.sslContexts){

            @Override
            Map<SSLConfiguration, SSLContextHolder> loadSSLConfigurations() {
                return Collections.emptyMap();
            }

            @Override
            SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
                SSLContextHolder holder = (SSLContextHolder)SSLService.this.sslContexts.get(sslConfiguration);
                if (holder == null) {
                    holder = SSLService.this.createSslContext(sslConfiguration);
                }
                return holder;
            }
        };
    }

    public SSLIOSessionStrategy sslIOSessionStrategy(Settings settings) {
        SSLConfiguration config = this.sslConfiguration(settings);
        SSLContext sslContext = this.sslContext(config);
        String[] ciphers = this.supportedCiphers(this.sslParameters(sslContext).getCipherSuites(), config.cipherSuites(), false);
        String[] supportedProtocols = config.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        HostnameVerifier verifier = config.verificationMode().isHostnameVerificationEnabled() ? SSLIOSessionStrategy.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        return this.sslIOSessionStrategy(sslContext, supportedProtocols, ciphers, verifier);
    }

    SSLParameters sslParameters(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters();
    }

    SSLIOSessionStrategy sslIOSessionStrategy(SSLContext sslContext, String[] protocols, String[] ciphers, HostnameVerifier verifier) {
        return new SSLIOSessionStrategy(sslContext, protocols, ciphers, verifier);
    }

    public SSLSocketFactory sslSocketFactory(Settings settings) {
        SSLConfiguration sslConfiguration = this.sslConfiguration(settings);
        SSLSocketFactory socketFactory = this.sslContext(sslConfiguration).getSocketFactory();
        return new SecuritySSLSocketFactory(socketFactory, sslConfiguration.supportedProtocols().toArray(Strings.EMPTY_ARRAY), this.supportedCiphers(socketFactory.getSupportedCipherSuites(), sslConfiguration.cipherSuites(), false));
    }

    public SSLEngine createSSLEngine(Settings settings, Settings fallbackSettings) {
        return this.createSSLEngine(settings, fallbackSettings, null, -1);
    }

    public SSLEngine createSSLEngine(Settings settings, Settings fallbackSettings, String host, int port) {
        SSLConfiguration configuration = this.sslConfiguration(settings, fallbackSettings);
        return this.createSSLEngine(configuration, host, port);
    }

    public SSLEngine createSSLEngine(SSLConfiguration configuration, String host, int port) {
        SSLContext sslContext = this.sslContext(configuration);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        String[] ciphers = this.supportedCiphers(sslEngine.getSupportedCipherSuites(), configuration.cipherSuites(), false);
        String[] supportedProtocols = configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        SSLParameters parameters = new SSLParameters(ciphers, supportedProtocols);
        if (configuration.verificationMode().isHostnameVerificationEnabled() && host != null) {
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        parameters.setUseCipherSuitesOrder(true);
        configuration.sslClientAuth().configure(parameters);
        sslEngine.setSSLParameters(parameters);
        return sslEngine;
    }

    public boolean isConfigurationValidForServerUsage(SSLConfiguration sslConfiguration) {
        return sslConfiguration.keyConfig() != KeyConfig.NONE;
    }

    public boolean isSSLClientAuthEnabled(Settings settings) {
        return this.isSSLClientAuthEnabled(settings, Settings.EMPTY);
    }

    public boolean isSSLClientAuthEnabled(Settings settings, Settings fallback) {
        SSLConfiguration sslConfiguration = this.sslConfiguration(settings, fallback);
        return this.isSSLClientAuthEnabled(sslConfiguration);
    }

    public boolean isSSLClientAuthEnabled(SSLConfiguration sslConfiguration) {
        return sslConfiguration.sslClientAuth().enabled();
    }

    public VerificationMode getVerificationMode(Settings settings, Settings fallback) {
        SSLConfiguration sslConfiguration = this.sslConfiguration(settings, fallback);
        return sslConfiguration.verificationMode();
    }

    SSLContext sslContext() {
        return this.sslContextHolder(this.globalSSLConfiguration).sslContext();
    }

    SSLContext sslContext(SSLConfiguration configuration) {
        return this.sslContextHolder(configuration).sslContext();
    }

    SSLContextHolder sslContextHolder(SSLConfiguration sslConfiguration) {
        SSLContextHolder holder = this.sslContexts.get(sslConfiguration);
        if (holder == null) {
            throw new IllegalArgumentException("did not find a SSLContext for [" + sslConfiguration.toString() + "]");
        }
        return holder;
    }

    SSLConfiguration sslConfiguration(Settings settings) {
        if (settings.isEmpty()) {
            return this.globalSSLConfiguration;
        }
        return new SSLConfiguration(settings, this.globalSSLConfiguration);
    }

    public SSLConfiguration sslConfiguration(Settings settings, Settings fallbackSettings) {
        if (settings.isEmpty() && fallbackSettings.isEmpty()) {
            return this.globalSSLConfiguration;
        }
        SSLConfiguration fallback = this.sslConfiguration(fallbackSettings);
        return new SSLConfiguration(settings, fallback);
    }

    Collection<SSLConfiguration> getLoadedSSLConfigurations() {
        return Collections.unmodifiableSet(new HashSet<SSLConfiguration>(this.sslContexts.keySet()));
    }

    String[] supportedCiphers(String[] supportedCiphers, List<String> requestedCiphers, boolean log) {
        ArrayList<String> supportedCiphersList = new ArrayList<String>(requestedCiphers.size());
        LinkedList<String> unsupportedCiphers = new LinkedList<String>();
        for (String requestedCipher : requestedCiphers) {
            boolean found = false;
            for (String supportedCipher : supportedCiphers) {
                if (!supportedCipher.equals(requestedCipher)) continue;
                found = true;
                supportedCiphersList.add(requestedCipher);
                break;
            }
            if (found) continue;
            unsupportedCiphers.add(requestedCipher);
        }
        if (supportedCiphersList.isEmpty()) {
            throw new IllegalArgumentException("none of the ciphers " + Arrays.toString(requestedCiphers.toArray()) + " are supported by this JVM");
        }
        if (log && !unsupportedCiphers.isEmpty()) {
            this.logger.error("unsupported ciphers [{}] were requested but cannot be used in this JVM, however there are supported ciphers that will be used [{}]. If you are trying to use ciphers with a key length greater than 128 bits on an Oracle JVM, you will need to install the unlimited strength JCE policy files.", unsupportedCiphers, supportedCiphersList);
        }
        return supportedCiphersList.toArray(new String[supportedCiphersList.size()]);
    }

    private SSLContextHolder createSslContext(SSLConfiguration sslConfiguration) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using ssl settings [{}]", (Object)sslConfiguration);
        }
        ReloadableTrustManager trustManager = new ReloadableTrustManager(sslConfiguration.trustConfig().createTrustManager(this.env), sslConfiguration.trustConfig());
        ReloadableX509KeyManager keyManager = new ReloadableX509KeyManager(sslConfiguration.keyConfig().createKeyManager(this.env), sslConfiguration.keyConfig());
        return this.createSslContext(keyManager, trustManager, sslConfiguration);
    }

    private SSLContextHolder createSslContext(ReloadableX509KeyManager keyManager, ReloadableTrustManager trustManager, SSLConfiguration sslConfiguration) {
        try {
            SSLContext sslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(sslConfiguration.supportedProtocols()));
            sslContext.init(new X509ExtendedKeyManager[]{keyManager}, new X509ExtendedTrustManager[]{trustManager}, null);
            this.supportedCiphers(sslContext.getSupportedSSLParameters().getCipherSuites(), sslConfiguration.cipherSuites(), true);
            return new SSLContextHolder(sslContext, trustManager, keyManager);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
        }
    }

    Map<SSLConfiguration, SSLContextHolder> loadSSLConfigurations() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, DestroyFailedException, KeyStoreException, OperatorCreationException {
        HashMap<SSLConfiguration, SSLContextHolder> sslConfigurations = new HashMap<SSLConfiguration, SSLContextHolder>();
        sslConfigurations.put(this.globalSSLConfiguration, this.createSslContext(this.globalSSLConfiguration));
        Settings transportSSLSettings = this.settings.getByPrefix(XPackSettings.TRANSPORT_SSL_PREFIX);
        ArrayList<Settings> sslSettingsList = new ArrayList<Settings>();
        sslSettingsList.add(SSLService.getHttpTransportSSLSettings(this.settings));
        sslSettingsList.add(this.settings.getByPrefix("xpack.http.ssl."));
        sslSettingsList.addAll(SSLService.getRealmsSSLSettings(this.settings));
        sslSettingsList.addAll(SSLService.getMonitoringExporterSettings(this.settings));
        sslSettingsList.forEach(sslSettings -> sslConfigurations.computeIfAbsent(new SSLConfiguration((Settings)sslSettings, this.globalSSLConfiguration), this::createSslContext));
        SSLConfiguration transportSSLConfiguration = new SSLConfiguration(transportSSLSettings, this.globalSSLConfiguration);
        this.transportSSLConfiguration.set((Object)transportSSLConfiguration);
        List<Settings> profileSettings = SSLService.getTransportProfileSSLSettings(this.settings);
        sslConfigurations.computeIfAbsent(transportSSLConfiguration, this::createSslContext);
        profileSettings.forEach(profileSetting -> sslConfigurations.computeIfAbsent(new SSLConfiguration((Settings)profileSetting, transportSSLConfiguration), this::createSslContext));
        return Collections.unmodifiableMap(sslConfigurations);
    }

    public Set<CertificateInfo> getLoadedCertificates() throws GeneralSecurityException, IOException {
        HashSet<CertificateInfo> certificates = new HashSet<CertificateInfo>();
        for (SSLConfiguration config : this.getLoadedSSLConfigurations()) {
            certificates.addAll(config.getDefinedCertificates(this.env));
        }
        return certificates;
    }

    private static List<Settings> getRealmsSSLSettings(Settings settings) {
        ArrayList<Settings> sslSettings = new ArrayList<Settings>();
        Settings realmsSettings = settings.getByPrefix(SecurityField.setting("authc.realms."));
        for (String name : realmsSettings.names()) {
            Settings realmSSLSettings = realmsSettings.getAsSettings(name).getByPrefix("ssl.");
            if (realmSSLSettings.isEmpty()) continue;
            sslSettings.add(realmSSLSettings);
        }
        return sslSettings;
    }

    private static List<Settings> getTransportProfileSSLSettings(Settings settings) {
        ArrayList<Settings> sslSettings = new ArrayList<Settings>();
        Map profiles = settings.getGroups("transport.profiles.", true);
        for (Map.Entry entry : profiles.entrySet()) {
            Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("xpack.security.ssl.");
            if (profileSettings.isEmpty()) continue;
            sslSettings.add(profileSettings);
        }
        return sslSettings;
    }

    public static Settings getHttpTransportSSLSettings(Settings settings) {
        Settings httpSSLSettings = settings.getByPrefix(XPackSettings.HTTP_SSL_PREFIX);
        if (httpSSLSettings.isEmpty()) {
            return httpSSLSettings;
        }
        Settings.Builder builder = Settings.builder().put(httpSSLSettings);
        if (builder.get("client_authentication") == null) {
            builder.put("client_authentication", (Enum)XPackSettings.HTTP_CLIENT_AUTH_DEFAULT);
        }
        return builder.build();
    }

    private static List<Settings> getMonitoringExporterSettings(Settings settings) {
        ArrayList<Settings> sslSettings = new ArrayList<Settings>();
        Map exportersSettings = settings.getGroups("xpack.monitoring.exporters.");
        for (Map.Entry entry : exportersSettings.entrySet()) {
            Settings exporterSSLSettings = ((Settings)entry.getValue()).getByPrefix("ssl.");
            if (exporterSSLSettings.isEmpty()) continue;
            sslSettings.add(exporterSSLSettings);
        }
        return sslSettings;
    }

    private static String sslContextAlgorithm(List<String> supportedProtocols) {
        if (supportedProtocols.isEmpty()) {
            return "TLSv1.2";
        }
        String algorithm = "SSL";
        Iterator<String> iterator = supportedProtocols.iterator();
        block29: while (iterator.hasNext()) {
            String supportedProtocol;
            block8 : switch (supportedProtocol = iterator.next()) {
                case "TLSv1.2": {
                    return "TLSv1.2";
                }
                case "TLSv1.1": {
                    if ("TLSv1.2".equals(algorithm)) continue block29;
                    algorithm = "TLSv1.1";
                    break;
                }
                case "TLSv1": {
                    switch (algorithm) {
                        case "TLSv1.2": 
                        case "TLSv1.1": {
                            break block8;
                        }
                    }
                    algorithm = "TLSv1";
                    break;
                }
                case "SSLv3": {
                    switch (algorithm) {
                        case "SSLv2": 
                        case "SSL": {
                            algorithm = "SSLv3";
                        }
                    }
                    break;
                }
                case "SSLv2": 
                case "SSLv2Hello": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("found unexpected value in supported protocols: " + supportedProtocol);
                }
            }
        }
        return algorithm;
    }

    static final class EmptyX509TrustManager
    extends X509ExtendedTrustManager {
        EmptyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            throw new CertificateException("no certificates are trusted");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static final class EmptyKeyManager
    extends X509ExtendedKeyManager {
        private EmptyKeyManager() {
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return new String[0];
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return new String[0];
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return new X509Certificate[0];
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return null;
        }
    }

    static final class SSLContextHolder {
        private final SSLContext context;
        private final ReloadableTrustManager trustManager;
        private final ReloadableX509KeyManager keyManager;

        SSLContextHolder(SSLContext context, ReloadableTrustManager trustManager, ReloadableX509KeyManager keyManager) {
            this.context = context;
            this.trustManager = trustManager;
            this.keyManager = keyManager;
        }

        SSLContext sslContext() {
            return this.context;
        }

        ReloadableX509KeyManager keyManager() {
            return this.keyManager;
        }

        ReloadableTrustManager trustManager() {
            return this.trustManager;
        }

        synchronized void reload() {
            this.trustManager.reload();
            this.keyManager.reload();
            SSLContextHolder.invalidateSessions(this.context.getClientSessionContext());
            SSLContextHolder.invalidateSessions(this.context.getServerSessionContext());
        }

        private static void invalidateSessions(SSLSessionContext sslSessionContext) {
            Enumeration<byte[]> sessionIds = sslSessionContext.getIds();
            while (sessionIds.hasMoreElements()) {
                byte[] sessionId = sessionIds.nextElement();
                sslSessionContext.getSession(sessionId).invalidate();
            }
        }
    }

    final class ReloadableX509KeyManager
    extends X509ExtendedKeyManager {
        private volatile X509ExtendedKeyManager keyManager;
        private final KeyConfig keyConfig;

        ReloadableX509KeyManager(X509ExtendedKeyManager keyManager, KeyConfig keyConfig) {
            this.keyManager = keyManager == null ? new EmptyKeyManager() : keyManager;
            this.keyConfig = keyConfig;
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.keyManager.getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.keyManager.chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.keyManager.getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return this.keyManager.chooseServerAlias(s, principals, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.keyManager.getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.keyManager.getPrivateKey(s);
        }

        @Override
        public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine engine) {
            return this.keyManager.chooseEngineClientAlias(strings, principals, engine);
        }

        @Override
        public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine engine) {
            return this.keyManager.chooseEngineServerAlias(s, principals, engine);
        }

        void reload() {
            X509ExtendedKeyManager loadedKeyManager = this.keyConfig.createKeyManager(SSLService.this.env);
            this.keyManager = loadedKeyManager == null ? new EmptyKeyManager() : loadedKeyManager;
        }

        X509ExtendedKeyManager getKeyManager() {
            return this.keyManager;
        }
    }

    final class ReloadableTrustManager
    extends X509ExtendedTrustManager {
        private volatile X509ExtendedTrustManager trustManager;
        private final TrustConfig trustConfig;

        ReloadableTrustManager(X509ExtendedTrustManager trustManager, TrustConfig trustConfig) {
            this.trustManager = trustManager == null ? new EmptyX509TrustManager() : trustManager;
            this.trustConfig = trustConfig;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            this.trustManager.checkClientTrusted(x509Certificates, s, socket);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            this.trustManager.checkServerTrusted(x509Certificates, s, socket);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            this.trustManager.checkClientTrusted(x509Certificates, s, sslEngine);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            this.trustManager.checkServerTrusted(x509Certificates, s, sslEngine);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.trustManager.checkClientTrusted(x509Certificates, s);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        void reload() {
            X509ExtendedTrustManager loadedTrustManager = this.trustConfig.createTrustManager(SSLService.this.env);
            this.trustManager = loadedTrustManager == null ? new EmptyX509TrustManager() : loadedTrustManager;
        }

        X509ExtendedTrustManager getTrustManager() {
            return this.trustManager;
        }
    }

    private static class SecuritySSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final String[] supportedProtocols;
        private final String[] ciphers;

        SecuritySSLSocketFactory(SSLSocketFactory delegate, String[] supportedProtocols, String[] ciphers) {
            this.delegate = delegate;
            this.supportedProtocols = supportedProtocols;
            this.ciphers = ciphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)this.delegate::createSocket));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(socket, host, port, autoClose)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port, localHost, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(address, port, localAddress, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        private void configureSSLSocket(SSLSocket socket) {
            SSLParameters parameters = new SSLParameters(this.ciphers, this.supportedProtocols);
            parameters.setUseCipherSuitesOrder(true);
            socket.setSSLParameters(parameters);
        }

        private static SSLSocket createWithPermissions(CheckedSupplier<Socket, IOException> supplier) throws IOException {
            return (SSLSocket)SocketAccess.doPrivileged(supplier);
        }
    }
}

